/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.state;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;

public class MementoStateManager
implements ICheatSheetStateManager {
    private IMemento memento;
    private CheatSheetElement element;
    private CheatSheetSaveHelper saveHelper = new CheatSheetSaveHelper();
    private Properties props;
    private ICheatSheetManager parentCsm;

    public MementoStateManager(IMemento memento, ICheatSheetManager parentCsm) {
        this.memento = memento;
        this.parentCsm = parentCsm;
    }

    @Override
    public Properties getProperties() {
        if (this.memento == null) {
            return null;
        }
        if (this.props == null) {
            this.props = this.saveHelper.loadFromMemento(this.memento);
        }
        return this.props;
    }

    @Override
    public CheatSheetManager getCheatSheetManager() {
        CheatSheetManager result = new CheatSheetManager(this.element);
        if (this.getProperties() != null) {
            result.setData((Map)((Hashtable)this.getProperties().get("CSMData")));
        }
        result.setParent(this.parentCsm);
        return result;
    }

    @Override
    public void setElement(CheatSheetElement element) {
        this.element = element;
    }

    @Override
    public IStatus saveState(Properties properties, CheatSheetManager manager) {
        return Status.OK_STATUS;
    }
}

