/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.groupkit.GroupThemeAdapter;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    private String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        BoxDimensions trimmings = this.getThemeAdapter().getTrimmingSize(this);
        int trimmingsWidth = trimmings.left + trimmings.right;
        int trimmingsHeight = trimmings.top + trimmings.bottom;
        BoxDimensions border = this.getBorder();
        int borderWidth = border.left + border.right;
        int borderHeight = border.top + border.bottom;
        int width = Math.max(0, bounds.width - trimmingsWidth - borderWidth);
        int height = Math.max(0, bounds.height - trimmingsHeight - borderHeight);
        return new Rectangle(trimmings.left, trimmings.top, width, height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        BoxDimensions trimmings = this.getThemeAdapter().getTrimmingSize(this);
        int trimmingsWidth = trimmings.left + trimmings.right;
        int trimmingsHeight = trimmings.top + trimmings.bottom;
        BoxDimensions border = this.getBorder();
        int borderWidth = border.left + border.right;
        int borderHeight = border.top + border.bottom;
        return super.computeTrim(x - trimmings.left - border.left, y - trimmings.top - border.top, width + trimmingsWidth + borderWidth, height + trimmingsHeight + borderHeight);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point result = super.computeSize(wHint, hHint, changed);
        int length = this.text.length();
        if (length != 0) {
            Font font = this.getFont();
            Point stringExtent = TextSizeUtil.stringExtent(font, this.text);
            BoxDimensions headTrimmings = this.getThemeAdapter().getHeaderTrimmingSize(this);
            int headerWidth = stringExtent.x + headTrimmings.left + headTrimmings.right;
            result.x = Math.max(result.x, headerWidth);
        }
        return result;
    }

    private GroupThemeAdapter getThemeAdapter() {
        return (GroupThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    private static int checkStyle(int style) {
        int result = style | 0x80000;
        return result & 0xFFFFFCFF;
    }
}

