/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

final class DateTimeLCAUtil {
    private static final String TYPE = "rwt.widgets.DateTime";
    private static final String[] ALLOWED_STYLES = new String[]{"DATE", "TIME", "CALENDAR", "SHORT", "MEDIUM", "LONG", "DROP_DOWN", "BORDER"};
    private static final String PROP_CELL_SIZE = "cellSize";
    private static final String PROP_MONTH_NAMES = "monthNames";
    private static final String PROP_WEEKDAY_NAMES = "weekdayNames";
    private static final String PROP_WEEKDAY_SHORT_NAMES = "weekdayShortNames";
    private static final String PROP_DATE_SEPARATOR = "dateSeparator";
    private static final String PROP_DATE_PATTERN = "datePattern";
    private static final String PROP_SUB_WIDGETS_BOUNDS = "subWidgetsBounds";
    private static final String PROP_SELECTION_LISTENER = "selection";

    private DateTimeLCAUtil() {
    }

    static void preserveValues(DateTime dateTime) {
        ControlLCAUtil.preserveValues(dateTime);
        WidgetLCAUtil.preserveCustomVariant(dateTime);
        WidgetLCAUtil.preserveListener(dateTime, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(dateTime));
    }

    static void renderInitialization(DateTime dateTime) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(dateTime.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(dateTime, ALLOWED_STYLES));
    }

    static void renderChanges(DateTime dateTime) {
        ControlLCAUtil.renderChanges(dateTime);
        WidgetLCAUtil.renderCustomVariant(dateTime);
        WidgetLCAUtil.renderListener(dateTime, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(dateTime), false);
    }

    static void renderCellSize(DateTime dateTime) {
        Point cellSize = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getCellSize();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_CELL_SIZE, new int[]{cellSize.x, cellSize.y});
    }

    static void renderMonthNames(DateTime dateTime) {
        String[] monthNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getMonthNames();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_MONTH_NAMES, monthNames);
    }

    static void renderWeekdayNames(DateTime dateTime) {
        String[] weekdayNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getWeekdayNames();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_WEEKDAY_NAMES, weekdayNames);
    }

    static void renderWeekdayShortNames(DateTime dateTime) {
        String[] weekdayShortNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getWeekdayShortNames();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_WEEKDAY_SHORT_NAMES, weekdayShortNames);
    }

    static void renderDateSeparator(DateTime dateTime) {
        String dateSeparator = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getDateSeparator();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_DATE_SEPARATOR, dateSeparator);
    }

    static void renderDatePattern(DateTime dateTime) {
        String datePattern = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getDatePattern();
        IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
        clientObject.set(PROP_DATE_PATTERN, datePattern);
    }

    static void preserveSubWidgetsBounds(DateTime dateTime, SubWidgetBounds[] subWidgetBounds) {
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_SUB_WIDGETS_BOUNDS, subWidgetBounds);
    }

    static void renderSubWidgetsBounds(DateTime dateTime, SubWidgetBounds[] subWidgetBounds) {
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_SUB_WIDGETS_BOUNDS, subWidgetBounds)) {
            int[][] bounds = new int[subWidgetBounds.length][5];
            int i = 0;
            while (i < bounds.length) {
                bounds[i] = new int[]{subWidgetBounds[i].id, subWidgetBounds[i].x, subWidgetBounds[i].y, subWidgetBounds[i].width, subWidgetBounds[i].height};
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject(dateTime);
            clientObject.set(PROP_SUB_WIDGETS_BOUNDS, bounds);
        }
    }

    static SubWidgetBounds getSubWidgetBounds(DateTime dateTime, int subWidgetId) {
        Rectangle bounds = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getBounds(subWidgetId);
        return new SubWidgetBounds(subWidgetId, bounds);
    }

    private static IDateTimeAdapter getDateTimeAdapter(DateTime dateTime) {
        return dateTime.getAdapter(IDateTimeAdapter.class);
    }

    static final class SubWidgetBounds {
        public final int id;
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public SubWidgetBounds(int id, Rectangle bounds) {
            ParamCheck.notNull(bounds, "subWidgetBounds");
            this.id = id;
            this.x = bounds.x;
            this.y = bounds.y;
            this.width = bounds.width;
            this.height = bounds.height;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof SubWidgetBounds) {
                SubWidgetBounds other = (SubWidgetBounds)obj;
                result = other.id == this.id && other.x == this.x && other.y == this.y && other.width == this.width && other.height == this.height;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "SubWidgetBounds#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

