/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.internal.widgets.controldecoratorkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlDecorator;
import org.eclipse.swt.widgets.Widget;

public class ControlDecoratorLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ControlDecorator";
    private static final String[] ALLOWED_STYLES = new String[]{"TOP", "BOTTOM", "LEFT", "RIGHT", "CENTER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_SHOW_HOVER = "showHover";
    private static final String PROP_SELECTION_LISTENER = "selection";

    public void preserveValues(Widget widget) {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.preserveBounds(decorator, decorator.getBounds());
        WidgetLCAUtil.preserveProperty((Widget)decorator, PROP_TEXT, decorator.getText());
        WidgetLCAUtil.preserveProperty((Widget)decorator, PROP_IMAGE, decorator.getImage());
        WidgetLCAUtil.preserveProperty((Widget)decorator, PROP_VISIBLE, decorator.isVisible());
        WidgetLCAUtil.preserveProperty((Widget)decorator, PROP_SHOW_HOVER, decorator.getShowHover());
        WidgetLCAUtil.preserveListener(decorator, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(decorator));
    }

    public void readData(Widget widget) {
        ControlDecoratorLCA.readSelectionEvent((ControlDecorator)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(decorator);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(decorator.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(decorator, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.renderBounds(decorator, decorator.getBounds());
        WidgetLCAUtil.renderProperty((Widget)decorator, PROP_TEXT, decorator.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)decorator, PROP_IMAGE, decorator.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)decorator, PROP_VISIBLE, decorator.isVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)decorator, PROP_SHOW_HOVER, decorator.getShowHover(), true);
        WidgetLCAUtil.renderListener(decorator, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(decorator), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void readSelectionEvent(ControlDecorator decorator) {
        if (WidgetLCAUtil.wasEventSent(decorator, "org.eclipse.swt.events.widgetSelected")) {
            ControlDecoratorLCA.processSelectionEvent(decorator, 13);
        }
        if (WidgetLCAUtil.wasEventSent(decorator, "org.eclipse.swt.events.widgetDefaultSelected")) {
            ControlDecoratorLCA.processSelectionEvent(decorator, 14);
        }
    }

    private static void processSelectionEvent(ControlDecorator decorator, int id) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        SelectionEvent event = new SelectionEvent(decorator, null, id, bounds, stateMask, "", true, 0);
        event.processEvent();
    }
}

