/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rwt.internal.engine.PostDeserialization;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

class ImageSerializer {
    private final Image image;

    ImageSerializer(Image image) {
        this.image = image;
    }

    void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new SerializableBytes(this.getImageBytes()));
    }

    void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        SerializableBytes imageBytes = (SerializableBytes)stream.readObject();
        stream.registerValidation(new PostDeserializationValidation(imageBytes), 0);
    }

    private byte[] getImageBytes() {
        String resourceName = this.image.internalImage.getResourceName();
        InputStream inputStream = this.getResourceManager().getRegisteredContent(resourceName);
        try {
            return ResourceUtil.readBinary(inputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private ISessionStore getSessionStore() {
        Display display = (Display)this.image.getDevice();
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter.getSessionStore();
    }

    private IResourceManager getResourceManager() {
        return ApplicationContextUtil.get(this.getSessionStore()).getResourceManager();
    }

    private class PostDeserializationValidation
    implements ObjectInputValidation {
        private final SerializableBytes imageBytes;

        PostDeserializationValidation(SerializableBytes imageBytes) {
            this.imageBytes = imageBytes;
        }

        public void validateObject() throws InvalidObjectException {
            PostDeserialization.addProcessor(ImageSerializer.this.getSessionStore(), new Runnable(){

                public void run() {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(((PostDeserializationValidation)PostDeserializationValidation.this).imageBytes.data);
                    ImageSerializer.this.getResourceManager().register(((ImageSerializer)((PostDeserializationValidation)PostDeserializationValidation.this).ImageSerializer.this).image.internalImage.getResourceName(), inputStream);
                }
            });
        }
    }

    private static class SerializableBytes
    implements Serializable {
        final byte[] data;

        SerializableBytes(byte[] data) {
            this.data = data;
        }
    }
}

