/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;

public class MenuItem
extends Item {
    private final Menu parent;
    private Menu menu;
    private DisposeListener menuDisposeListener;
    private boolean selection;
    private int userId;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        ItemHolder.getItemHolder(parent).add(this);
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        ItemHolder.getItemHolder(parent).insert(this, index);
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (this.menu != menu) {
            if ((this.style & 0x40) == 0) {
                SWT.error(27);
            }
            if (menu != null) {
                if (menu.isDisposed()) {
                    SWT.error(5);
                }
                if ((menu.getStyle() & 4) == 0) {
                    SWT.error(21);
                }
                if (menu.getParent() != this.getParent().getParent()) {
                    SWT.error(32);
                }
            }
            this.removeMenuDisposeListener();
            if (this.menu != null) {
                this.menu.cascade = null;
            }
            this.menu = menu;
            if (menu != null) {
                menu.cascade = this;
            }
            this.addMenuDisposeListener();
        }
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public void setID(int id) {
        this.checkWidget();
        if (id < 0) {
            this.error(5);
        }
        this.userId = id;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            super.setImage(image);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!enabled) {
            this.state |= 8;
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.checkWidget();
        if ((this.style & 0x30) != 0) {
            this.selection = selection;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.addListener(this, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.removeListener(this, listener);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        ArmEvent.addListener(this, listener);
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        ArmEvent.removeListener(this, listener);
    }

    final void releaseChildren() {
        if (this.menu != null) {
            this.removeMenuDisposeListener();
            this.menu.dispose();
            this.menu = null;
        }
    }

    final void releaseParent() {
        super.releaseParent();
        ItemHolder.getItemHolder(this.parent).remove(this);
    }

    String getNameText() {
        String result = (this.style & 2) != 0 ? "|" : super.getNameText();
        return result;
    }

    private void addMenuDisposeListener() {
        if (this.menu != null) {
            if (this.menuDisposeListener == null) {
                this.menuDisposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        MenuItem.this.menu = null;
                    }
                };
            }
            this.menu.addDisposeListener(this.menuDisposeListener);
        }
    }

    private void removeMenuDisposeListener() {
        if (this.menu != null) {
            this.menu.removeDisposeListener(this.menuDisposeListener);
        }
    }

    private static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }
}

