/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.ContextManagerFactory;
import org.eclipse.ui.internal.contexts.ContextManagerLegacyWrapper;

public class WorkbenchContextSupport
implements IWorkbenchContextSupport {
    private Map activationsBySubmission = null;
    private IContextService contextService;
    private ContextManagerLegacyWrapper contextManagerWrapper;
    private final Workbench workbench;
    static /* synthetic */ Class class$0;

    public WorkbenchContextSupport(Workbench workbenchToSupport, ContextManager contextManager) {
        this.workbench = workbenchToSupport;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.contextService = (IContextService)this.workbench.getService(clazz);
        this.contextManagerWrapper = ContextManagerFactory.getContextManagerWrapper(contextManager);
    }

    public final void addEnabledSubmission(EnabledSubmission enabledSubmission) {
        int sourcePriorities = 0;
        if (enabledSubmission.getActivePartId() != null) {
            sourcePriorities |= 0x400000;
        }
        if (enabledSubmission.getActiveShell() != null) {
            sourcePriorities |= 0x4400;
        }
        if (enabledSubmission.getActiveWorkbenchPartSite() != null) {
            sourcePriorities |= 0x4000000;
        }
        IContextActivation activation = this.contextService.activateContext(enabledSubmission.getContextId(), new LegacyHandlerSubmissionExpression(enabledSubmission.getActivePartId(), enabledSubmission.getActiveShell(), enabledSubmission.getActiveWorkbenchPartSite()));
        if (this.activationsBySubmission == null) {
            this.activationsBySubmission = new HashMap();
        }
        this.activationsBySubmission.put(enabledSubmission, activation);
    }

    public final void addEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.addEnabledSubmission((EnabledSubmission)submissionItr.next());
        }
    }

    public final IContextManager getContextManager() {
        return this.contextManagerWrapper;
    }

    public final int getShellType(Shell shell) {
        return this.contextService.getShellType(shell);
    }

    public final boolean registerShell(Shell shell, int type) {
        return this.contextService.registerShell(shell, type);
    }

    public final void removeEnabledSubmission(EnabledSubmission enabledSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        Object value = this.activationsBySubmission.remove(enabledSubmission);
        if (value instanceof IContextActivation) {
            IContextActivation activation = (IContextActivation)value;
            this.contextService.deactivateContext(activation);
        }
    }

    public final void removeEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.removeEnabledSubmission((EnabledSubmission)submissionItr.next());
        }
    }

    public final boolean unregisterShell(Shell shell) {
        return this.contextService.unregisterShell(shell);
    }
}

