/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.Decorator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ControlDecorator
extends Decorator {
    public static final String KEY_DECORATIONS = "decorations";
    private final Composite parent;
    private Image image;
    private String text;
    private boolean visible = true;
    private boolean showOnlyOnFocus;
    private boolean showHover = true;
    private boolean hasFocus;
    private int marginWidth;
    private FocusListener focusListener;

    public ControlDecorator(Control control, int style, Composite composite) {
        super(control, style);
        this.parent = ControlDecorator.getParent(control, composite);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ControlDecorator.this.removeFocusListener();
            }
        });
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
    }

    public boolean getShowOnlyOnFocus() {
        this.checkWidget();
        return this.showOnlyOnFocus;
    }

    public void setShowOnlyOnFocus(boolean showOnlyOnFocus) {
        this.checkWidget();
        if (this.showOnlyOnFocus != showOnlyOnFocus) {
            this.showOnlyOnFocus = showOnlyOnFocus;
            if (showOnlyOnFocus) {
                this.addFocusListener();
            } else {
                this.removeFocusListener();
            }
        }
    }

    public boolean getShowHover() {
        this.checkWidget();
        return this.showHover;
    }

    public void setShowHover(boolean showHover) {
        this.checkWidget();
        this.showHover = showHover;
    }

    public int getMarginWidth() {
        this.checkWidget();
        return this.marginWidth;
    }

    public void setMarginWidth(int marginWidth) {
        this.checkWidget();
        this.marginWidth = marginWidth;
    }

    public void show() {
        this.checkWidget();
        this.visible = true;
    }

    public void hide() {
        this.checkWidget();
        this.visible = false;
    }

    public boolean isVisible() {
        Control control;
        this.checkWidget();
        boolean result = true;
        if (!this.visible) {
            result = false;
        }
        if ((control = (Control)this.getDecoratedWidget()) == null || control.isDisposed() || this.image == null) {
            result = false;
        }
        if (control != null && !control.isVisible()) {
            result = false;
        }
        if (this.showOnlyOnFocus) {
            result = result && this.hasFocus;
        }
        return result;
    }

    public Rectangle getBounds() {
        Rectangle result;
        this.checkWidget();
        Control control = (Control)this.getDecoratedWidget();
        if (this.image != null && control != null) {
            Rectangle imageBounds = this.image.getBounds();
            Rectangle controlBounds = control.getBounds();
            int left = (this.getStyle() & 0x20000) == 131072 ? controlBounds.x + controlBounds.width + this.marginWidth : controlBounds.x - imageBounds.width - this.marginWidth;
            int top = (this.getStyle() & 0x80) == 128 ? controlBounds.y : ((this.getStyle() & 0x400) == 1024 ? controlBounds.y + controlBounds.height - imageBounds.height : controlBounds.y + (controlBounds.height - imageBounds.height) / 2);
            Point globalPoint = control.getParent().toDisplay(left, top);
            Point targetPoint = this.parent.toControl(globalPoint);
            result = new Rectangle(targetPoint.x, targetPoint.y, imageBounds.width, imageBounds.height);
        } else {
            result = new Rectangle(0, 0, 0, 0);
        }
        return result;
    }

    public Control getControl() {
        this.checkWidget();
        return (Control)this.getDecoratedWidget();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    private static Composite getParent(Control control, Composite composite) {
        Composite result = composite;
        if (composite == null) {
            result = control.getParent();
        }
        return result;
    }

    private void addFocusListener() {
        Control control;
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent event) {
                    ControlDecorator.this.hasFocus = true;
                }

                public void focusLost(FocusEvent event) {
                    ControlDecorator.this.hasFocus = false;
                }
            };
        }
        if ((control = (Control)this.getDecoratedWidget()) != null && !control.isDisposed()) {
            control.addFocusListener(this.focusListener);
        }
    }

    private void removeFocusListener() {
        Control control = (Control)this.getDecoratedWidget();
        if (this.focusListener != null && control != null && !control.isDisposed()) {
            control.removeFocusListener(this.focusListener);
        }
    }
}

