/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.provider.jms.container.AbstractJMSServer;
import org.eclipse.ecf.provider.jms.container.IJMSQueueContainer;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.container.LBRegistrySharedObject;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;

public abstract class AbstractLBQueueProducerContainer
extends AbstractJMSServer
implements IJMSQueueContainer {
    private Object queueConnectLock = new Object();
    private Connection connection;
    private Session session;
    private Queue queue;
    private MessageProducer messageProducer;
    private TemporaryQueue responseQueue;
    private LBRegistrySharedObject lbRegistry;
    private JMSID queueID;
    Object registryLock = new Object();

    public AbstractLBQueueProducerContainer(JMSContainerConfig config, JMSID queueID) {
        super(config);
        this.setQueueID(queueID);
    }

    protected JMSID getQueueID() {
        return this.queueID;
    }

    protected void setQueueID(JMSID queueID) {
        this.queueID = queueID;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    public TemporaryQueue getResponseQueue() {
        return this.responseQueue;
    }

    protected Object getQueueConnectLock() {
        return this.queueConnectLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupJMSQueueProducer(JMSID jmsTargetID) throws JMSException {
        Object object = this.getQueueConnectLock();
        synchronized (object) {
            String jmsServerString = jmsTargetID.getBroker();
            String messageQueueName = jmsTargetID.getTopicOrQueueName();
            ConnectionFactory connectionFactory = this.getQueueConnectionFactory(jmsServerString, null);
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.queue = this.session.createQueue(messageQueueName);
            this.messageProducer = this.session.createProducer((Destination)this.queue);
            this.responseQueue = this.session.createTemporaryQueue();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(IRemoteServiceContainerAdapter.class)) {
            return this.getRegistry();
        }
        return super.getAdapter(adapter);
    }

    LBRegistrySharedObject createAndAddLBRegistry() {
        ID soID = IDFactory.getDefault().createStringID(IRemoteServiceContainerAdapter.class.getName());
        this.lbRegistry = new LBRegistrySharedObject(this);
        try {
            this.getSharedObjectManager().addSharedObject(soID, (ISharedObject)this.lbRegistry, null);
        }
        catch (Exception exception) {
            throw new RuntimeException("createAndAddLBRegistry cannot add shared object");
        }
        return this.lbRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object getRegistry() {
        Object object = this.registryLock;
        synchronized (object) {
            if (this.lbRegistry == null) {
                this.createAndAddLBRegistry();
            }
            return this.lbRegistry;
        }
    }
}

