/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceContainerInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJMSContainerInstantiator
extends RemoteServiceContainerInstantiator {
    public static final String ID_PARAM = "id";
    public static final String KEEPALIVE_PARAM = "keepAlive";

    protected static Map<String, List<String>> createMap(String exporter, List<String> importers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (importers != null) {
            map.put(exporter, importers);
        }
        return map;
    }

    public AbstractJMSContainerInstantiator(String exporter, String importer) {
        super(Arrays.asList(exporter), AbstractJMSContainerInstantiator.createMap(exporter, Arrays.asList(importer)));
    }

    public AbstractJMSContainerInstantiator(String exporter, List<String> importers) {
        super(Arrays.asList(exporter), AbstractJMSContainerInstantiator.createMap(exporter, importers));
    }

    public AbstractJMSContainerInstantiator(List<String> exporterConfigs, Map<String, List<String>> exporterConfigToImporterConfig) {
        super(exporterConfigs, exporterConfigToImporterConfig);
    }

    protected JMSID getJMSIDFromParameter(Object p) {
        return this.getJMSIDFromParameter(p, null);
    }

    protected JMSID getJMSIDFromParameter(Object p, String def) {
        if (p == null && def == null) {
            return null;
        }
        if (p instanceof String) {
            return (JMSID)IDFactory.getDefault().createID("ecf.namespace.jmsid", (String)p);
        }
        if (p instanceof JMSID) {
            return (JMSID)((Object)p);
        }
        return (JMSID)IDFactory.getDefault().createID("ecf.namespace.jmsid", def);
    }

    protected JMSID getJMSIDFromParams(Map<String, ?> params, String def) {
        if (params == null) {
            return this.getJMSIDFromParameter(def, null);
        }
        return this.getJMSIDFromParameter(params.get(ID_PARAM), def);
    }

    protected Integer getKeepAlive(Map<String, ?> params, Integer def) {
        if (params == null) {
            return def;
        }
        return (Integer)this.getParameterValue(params, KEEPALIVE_PARAM, Integer.class, def);
    }
}

