/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.host;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.mgmt.framework.IBundleEventHandler;
import org.eclipse.ecf.mgmt.framework.IBundleManager;
import org.eclipse.ecf.mgmt.framework.IServiceEventHandler;
import org.eclipse.ecf.mgmt.framework.IServiceManager;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallEventHandler;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.IExportableServiceCallbackAssociator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;

@Component(immediate=true)
public class KarafManagerExporter {
    private ServiceReference<IBundleManager> bmRef;
    private ServiceReference<IServiceManager> smRef;
    private ServiceReference<FeatureInstallManager> fiRef;
    private IExportableServiceCallbackAssociator associator;
    private ExportRegistration bmReg;
    private ExportRegistration smReg;
    private ExportRegistration fiReg;
    private static final String SERVICE_EXPORTED_CONFIGS = "service.exported.configs";
    private static final String EXPORT_CONFIG = "ecf.jms.mqtt.manager";
    private static final String EXPORT_CONFIG_ID = "tcp://iot.eclipse.org:1883/kura/remoteservices";

    @Reference
    void bindAssociator(IExportableServiceCallbackAssociator a) {
        this.associator = a;
    }

    void unbindAssociator(IExportableServiceCallbackAssociator a) {
        this.associator = null;
    }

    @Reference
    void bindBundleManager(ServiceReference<IBundleManager> r) {
        this.bmRef = r;
    }

    void unbindBundleManager(ServiceReference<IBundleManager> r) {
        this.bmRef = null;
    }

    @Reference
    void bindServiceManager(ServiceReference<IServiceManager> r) {
        this.smRef = r;
    }

    void unbindServiceManager(ServiceReference<IServiceManager> r) {
        this.smRef = null;
    }

    @Reference
    void bindKarafFeaturesInstallerManager(ServiceReference<FeatureInstallManager> r) {
        this.fiRef = r;
    }

    void unbindKarafFeaturesInstallerManager(ServiceReference<FeatureInstallManager> r) {
        this.fiRef = null;
    }

    @Activate
    public void activate(BundleContext c) throws Exception {
        this.associator.associateCallback(this.bmRef, IBundleEventHandler.class);
        this.associator.associateCallback(this.smRef, IServiceEventHandler.class);
        this.associator.associateCallback(this.fiRef, FeatureInstallEventHandler.class);
        Map<String, Object> props = this.createRemoteServiceProperties();
        Collection regs = this.associator.getRSA().exportService(this.bmRef, props);
        this.bmReg = (ExportRegistration)regs.iterator().next();
        Throwable t = this.bmReg.getException();
        if (t != null) {
            this.bmReg = null;
            throw new RuntimeException("Could not export BundleManager service");
        }
        regs = this.associator.getRSA().exportService(this.smRef, props);
        this.smReg = (ExportRegistration)regs.iterator().next();
        t = this.smReg.getException();
        if (t != null) {
            this.bmReg.close();
            this.bmReg = null;
            this.smReg = null;
            throw new RuntimeException("Could not export ServiceManager service");
        }
        regs = this.associator.getRSA().exportService(this.fiRef, props);
        this.fiReg = (ExportRegistration)regs.iterator().next();
        t = this.fiReg.getException();
        if (t != null) {
            this.bmReg.close();
            this.bmReg = null;
            this.smReg.close();
            this.smReg = null;
            this.fiReg.close();
            this.fiReg = null;
            throw new RuntimeException("Could not export ServiceManager service");
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.bmReg != null) {
            this.bmReg.close();
            this.bmReg = null;
        }
        if (this.smReg != null) {
            this.smReg.close();
            this.smReg = null;
        }
        if (this.fiReg != null) {
            this.fiReg.close();
            this.fiReg = null;
        }
    }

    private Map<String, Object> createRemoteServiceProperties() {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("service.exported.interfaces", "*");
        result.put("ecf.exported.async.interfaces", "*");
        Properties props = System.getProperties();
        String config = props.getProperty(SERVICE_EXPORTED_CONFIGS);
        if (config == null) {
            config = EXPORT_CONFIG;
        }
        result.put(SERVICE_EXPORTED_CONFIGS, config);
        String configid = props.getProperty(String.valueOf(config) + ".id");
        if (configid == null) {
            configid = EXPORT_CONFIG_ID;
        }
        result.put(String.valueOf(config) + ".id", configid);
        for (Object k : props.keySet()) {
            String key;
            if (!(k instanceof String) || !(key = (String)k).startsWith(config)) continue;
            result.put(key, props.get(key));
        }
        return result;
    }
}

