/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui.hyperlink;

import java.net.URI;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.internal.irc.ui.wizards.IRCConnectWizard;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.hyperlink.AbstractURLHyperlink;
import org.eclipse.jface.text.IRegion;

public class IRCHyperlink
extends AbstractURLHyperlink {
    private static final String ECF_IRC_CONTAINER_NAME = "ecf.irc.irclib";

    public IRCHyperlink(IRegion region, URI uri) {
        super(region, uri);
    }

    protected IConnectWizard createConnectWizard() {
        URI uri = this.getURI();
        String authAndPath = uri.getSchemeSpecificPart();
        while (authAndPath.startsWith("/")) {
            authAndPath = authAndPath.substring(1);
        }
        String fragment = uri.getFragment();
        if (fragment != null) {
            StringBuffer buf = new StringBuffer(authAndPath);
            buf.append("#").append(fragment);
            authAndPath = buf.toString();
        }
        return new IRCConnectWizard(authAndPath);
    }

    protected IContainer createContainer() throws ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(ECF_IRC_CONTAINER_NAME);
    }
}

