/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs;

import javax.inject.Inject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;

public class DecorationDialog
extends TitleAreaDialog {
    private Text textStyle;
    private String currentStyle = null;
    private String currentColor = null;
    private Combo predicateCombo;
    private IPredicate currentPredicate;
    private ComboViewer comboViewer;
    @Inject
    private IPredicatesConfManager predicateManager;

    public DecorationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void okPressed() {
        if (this.currentColor == null || this.currentStyle == null || this.currentPredicate == null) {
            this.setErrorMessage("Please fill all the fields");
            return;
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Please choose the style applied to relations matching the chosen predicate");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblStyle = new Label(container, 0);
        lblStyle.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStyle.setText("style :");
        this.textStyle = new Text(container, 2048);
        this.textStyle.setText("a quick brown fox jumps over the lazy dog");
        this.textStyle.setEditable(false);
        this.textStyle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button button_1 = new Button(container, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog font = new FontDialog(DecorationDialog.this.getShell());
                FontData result = font.open();
                if (result != null) {
                    FontData[] list = font.getFontList();
                    DecorationDialog.this.currentStyle = StringConverter.asString((FontData[])list);
                    JFaceResources.getFontRegistry().put(DecorationDialog.this.currentStyle, list);
                    DecorationDialog.this.textStyle.setFont(JFaceResources.getFontRegistry().get(DecorationDialog.this.currentStyle));
                    RGB rgb = font.getRGB();
                    if (rgb != null) {
                        DecorationDialog.this.currentColor = StringConverter.asString((RGB)rgb);
                        JFaceResources.getColorRegistry().put(DecorationDialog.this.currentColor, rgb);
                        DecorationDialog.this.textStyle.setForeground(JFaceResources.getColorRegistry().get(DecorationDialog.this.currentColor));
                    }
                }
            }
        });
        button_1.setText("...");
        Label lblPredicate = new Label(container, 0);
        lblPredicate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPredicate.setText("predicate : ");
        this.comboViewer = new ComboViewer(container, 8);
        this.predicateCombo = this.comboViewer.getCombo();
        this.predicateCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)));
        this.comboViewer.setInput((Object)this.predicateManager.getPredicates(true));
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structured;
                if (DecorationDialog.this.comboViewer.getSelection() instanceof IStructuredSelection && (structured = (IStructuredSelection)DecorationDialog.this.comboViewer.getSelection()).getFirstElement() instanceof IPredicate) {
                    IPredicate p = (IPredicate)structured.getFirstElement();
                    DecorationDialog.this.currentPredicate = p;
                    return;
                }
                DecorationDialog.this.currentPredicate = null;
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public String getStyle() {
        return this.currentStyle;
    }

    public String getColor() {
        return this.currentColor;
    }

    public IPredicate getPredicate() {
        return this.currentPredicate;
    }
}

