/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.visitors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.emf.utils.EMFUtils;
import org.polarsys.reqcycle.uri.utils.ReachableUtils;
import org.polarsys.reqcycle.uri.visitors.IVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class EMFVisitable
implements IVisitable,
IAdaptable {
    Resource resource = null;
    private URI uri;

    public EMFVisitable(URI uri) {
        this.uri = uri;
    }

    private Resource getResource(URI uri) {
        ResourceSet set = this.getResourceSet();
        Resource r = null;
        try {
            r = set.getResource(uri.trimFragment(), true);
        }
        catch (WrappedException wrappedException) {
            r = set.getResource(uri.trimFragment(), false);
        }
        return r;
    }

    protected ResourceSet getResourceSet() {
        return EMFUtils.getFAURSWithPathMaps();
    }

    public void accept(IVisitor visitor) {
        visitor.start((IAdaptable)this);
        this.resource = this.getResource(this.uri);
        if (this.resource != null) {
            Iterator<EObject> i;
            Resource start = this.resource;
            if (this.uri.fragment() != null && this.uri.fragment().length() > 0) {
                start = this.resource.getEObject(this.uri.fragment());
            }
            if (visitor.visit((Object)start, (IAdaptable)this) && (i = this.getAllProperContents((Notifier)start)) != null) {
                while (i.hasNext()) {
                    if (!visitor.visit((Object)i.next(), (IAdaptable)this)) break;
                }
            }
        }
        visitor.end((IAdaptable)this);
    }

    public Iterator<EObject> getAllProperContents(Notifier start) {
        if (start instanceof EObject) {
            return EcoreUtil.getAllContents((EObject)((EObject)start), (boolean)false);
        }
        if (start instanceof Resource) {
            return EcoreUtil.getAllProperContents((Resource)((Resource)start), (boolean)false);
        }
        return null;
    }

    public void dispose() {
        if (this.resource != null) {
            ResourceSet set = this.resource.getResourceSet();
            if (set != null) {
                int i = 0;
                while (i < set.getResources().size()) {
                    try {
                        ((Resource)set.getResources().get(i)).unload();
                    }
                    catch (Exception exception) {}
                    set.getResources().clear();
                    ++i;
                }
            } else {
                try {
                    this.resource.unload();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getResourceTimeStamp() {
        long timeStamp = 0L;
        boolean error = false;
        if (this.uri.isPlatformResource()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.uri.toPlatformString(true)));
            if (file != null && file.exists()) {
                timeStamp = file.getLocalTimeStamp();
            } else {
                error = true;
            }
        }
        if (timeStamp == 0L && !error && this.uri.isFile()) {
            File f = new File(this.uri.path());
            if (f.exists()) {
                timeStamp = f.lastModified();
            } else {
                error = true;
            }
        }
        if (timeStamp == 0L && !error) {
            this.resource = this.getResource(this.uri);
            timeStamp = this.resource.getTimeStamp();
        }
        if (!(error || timeStamp != -1L && timeStamp != 0L)) {
            try {
                return ReachableUtils.hashStream((InputStream)this.resource.getResourceSet().getURIConverter().createInputStream(this.resource.getURI()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(timeStamp);
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.getResource(this.uri);
        }
        return this.resource;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

