/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.ui.dialogs;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IFileState;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.impact.IVersionManager;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SelectVersionDialog
extends ValidatingTitleAreaDialog
implements IDoubleClickListener {
    private TreeViewer treeViewer;
    private Map<RepositoryProvider, Collection<IFileRevision>> history;
    private List<IFileState> localHistory;
    private RequirementSource requirementSource;
    private RequirementSource requirementSourceSelected;
    private String rsVersion;
    IVersionManager versionManager = (IVersionManager)ZigguratInject.make(IVersionManager.class);
    @Inject
    IDataManager dataManager;

    public SelectVersionDialog(Shell parentShell, RequirementSource requirementSource) {
        super(parentShell);
        ZigguratInject.inject((Object[])new Object[]{this});
        this.requirementSource = requirementSource;
        this.history = this.versionManager.getHistory(requirementSource);
        this.localHistory = this.versionManager.getLocalHistory(requirementSource);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select version");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof IFileRevision) {
                    IFileRevision fileRev = (IFileRevision)((IStructuredSelection)event.getSelection()).getFirstElement();
                    Date date = new Date(fileRev.getTimestamp());
                    SelectVersionDialog.this.rsVersion = date.toString();
                    SelectVersionDialog.this.requirementSourceSelected = SelectVersionDialog.this.versionManager.loadResource(fileRev, SelectVersionDialog.this.requirementSource.getDataModelURI(), SelectVersionDialog.this.requirementSource.getDefaultScope(), SelectVersionDialog.this.requirementSource.getName());
                } else if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof IFileState) {
                    IFileState fileState = (IFileState)((IStructuredSelection)event.getSelection()).getFirstElement();
                    Date date = new Date(fileState.getModificationTime());
                    SelectVersionDialog.this.rsVersion = date.toString();
                    SelectVersionDialog.this.requirementSourceSelected = SelectVersionDialog.this.versionManager.loadLocalHistoryResource(fileState, SelectVersionDialog.this.requirementSource.getDataModelURI(), SelectVersionDialog.this.requirementSource.getDefaultScope(), SelectVersionDialog.this.requirementSource.getName());
                } else if (((IStructuredSelection)event.getSelection()).getFirstElement().equals("Current")) {
                    SelectVersionDialog.this.requirementSourceSelected = (RequirementSource)EcoreUtil.copy((EObject)SelectVersionDialog.this.requirementSource);
                    SelectVersionDialog.this.rsVersion = "Current";
                } else {
                    SelectVersionDialog.this.requirementSourceSelected = null;
                }
                SelectVersionDialog.this.validateInput();
            }
        });
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.setInput(this.history.keySet());
        return area;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (SelectVersionDialog.this.requirementSourceSelected == null) {
                    return "A version must be selected";
                }
                return null;
            }
        };
    }

    public RequirementSource getRequirementSource() {
        return this.requirementSourceSelected;
    }

    public String getRSVersion() {
        return this.rsVersion;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.requirementSourceSelected != null) {
            this.close();
        }
    }

    private class VersionContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.addAll(SelectVersionDialog.this.history.keySet());
            if (SelectVersionDialog.this.localHistory != null) {
                list.add("Local History");
            }
            list.add("Current");
            return list.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RepositoryProvider) {
                return ((Collection)SelectVersionDialog.this.history.get((RepositoryProvider)parentElement)).toArray();
            }
            if (parentElement.equals("Local History")) {
                return SelectVersionDialog.this.localHistory.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RepositoryProvider) {
                return ((Collection)SelectVersionDialog.this.history.get((RepositoryProvider)element)).size() > 0;
            }
            if (element.equals("Local History")) {
                return SelectVersionDialog.this.localHistory.size() > 0;
            }
            return false;
        }
    }

    private class VersionLabelProvider
    extends LabelProvider {
        private VersionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof RepositoryProvider) {
                return ((RepositoryProvider)element).getID();
            }
            if (element instanceof IFileRevision) {
                Date date = new Date(((IFileRevision)element).getTimestamp());
                return date.toString();
            }
            if (element instanceof IFileState) {
                Date date = new Date(((IFileState)element).getModificationTime());
                return date.toString();
            }
            return super.getText(element);
        }
    }
}

