/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.reqcycle.emf.utils.EMFUtils;
import org.polarsys.reqcycle.ocl.ui.OCLConnector;
import org.polarsys.reqcycle.ocl.ui.SettingBean;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;

public class SettingPage
extends AbstractSettingPage {
    private Button browseButton;
    private Text tFile;
    protected static ILabelProvider labelProvider = new WorkbenchLabelProvider(){

        public Color getForeground(Object element) {
            return Display.getDefault().getSystemColor(2);
        }

        public Color getBackground(Object element) {
            return Display.getDefault().getSystemColor(1);
        }
    };
    protected static ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    };
    protected static ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            URI uri;
            Object o;
            if (selection.length == 1 && (o = selection[0]) instanceof IFile && EMFUtils.isEMF((URI)(uri = URI.createPlatformResourceURI((String)((IFile)o).getFullPath().toOSString(), (boolean)true)), (boolean)false)) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.polarsys.reqcycle.ocl", "Select a single EMF file");
        }
    };

    protected SettingPage(SettingBean bean) {
        super("OCL Connector settings", (AbstractStorageBean)bean);
        this.setDescription("Connector settings");
        this.setTitle("Connector OCL: settings page");
    }

    protected Composite doCreateSpecific(Composite parent) {
        Composite containerComposite = parent;
        containerComposite.setLayout((Layout)new GridLayout(4, false));
        Label fileLabel = new Label(containerComposite, 0);
        fileLabel.setText("EMF Model :");
        this.tFile = new Text(containerComposite, 2056);
        this.tFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tFile.setEnabled(false);
        this.browseButton = new Button(containerComposite, 0);
        this.browseButton.setText("Browse");
        this.setControl((Control)containerComposite);
        return containerComposite;
    }

    protected void hookListeners() {
        super.hookListeners();
        this.getDestinationFileSelectionListener();
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(SettingPage.this.getShell(), "Select a model", 0);
                int res = dialog.open();
                if (res == 0 && !(uris = dialog.getURIs()).isEmpty()) {
                    String extension;
                    URI uri = (URI)uris.get(0);
                    Set<String> EXTENSIONS = OCLConnector.loadExtensions();
                    if (EXTENSIONS.contains((extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length())).toLowerCase())) {
                        SettingPage.this.tFile.setText(((URI)uris.get(0)).toString());
                    } else {
                        SettingPage.this.tFile.setText("");
                        SettingPage.this.setErrorMessage("Your document is not supported. Retry and choose EMF file");
                    }
                }
            }
        });
    }

    public boolean isPageComplete() {
        boolean result = super.isPageComplete();
        String msg = this.getErrorMessage();
        if (msg == null) {
            msg = "";
        }
        if (this.tFile.getText() == null || this.tFile.getText() == "") {
            result = false;
            msg = String.valueOf(msg) + "Choose an EMF model \n";
        } else {
            URI uri;
            String uriString = this.tFile.getText();
            if (uriString != null && !uriString.isEmpty() && !EMFUtils.isEMF((URI)(uri = URI.createURI((String)uriString)), (boolean)false)) {
                result = false;
                msg = String.valueOf(msg) + "Selected file is not an EMF resource\n";
            }
        }
        if (!result) {
            this.setErrorMessage(msg);
        }
        return result;
    }

    protected void doSpecificInitDataBindings(DataBindingContext bindingContext) {
        ISWTObservableValue observeTextFileURITextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.tFile);
        IObservableValue uriBeanObserveValue = PojoProperties.value((String)"uri").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeTextFileURITextObserveWidget, uriBeanObserveValue, null, null);
    }
}

