/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.preference.pages;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IEnumerationType;
import org.polarsys.reqcycle.repository.data.types.IEnumerator;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.ETypeImpl;
import org.polarsys.reqcycle.repository.data.ui.Activator;
import org.polarsys.reqcycle.repository.data.ui.dialog.AddAttributeDialog;
import org.polarsys.reqcycle.repository.data.ui.dialog.AddTypeDialog;
import org.polarsys.reqcycle.repository.data.ui.dialog.NameDialog;
import org.polarsys.reqcycle.repository.data.ui.preference.PreferenceUiUtil;
import org.polarsys.reqcycle.repository.data.ui.preference.pages.DataModelsPreferencePage;

public class DataTypesPreferencePage
extends DataModelsPreferencePage {
    protected TableViewer tvTypes;
    protected Table tTypes;
    protected TableViewerColumn tvcTypesNames;
    protected TableViewerColumn tvcTypesTypes;
    protected TableViewer tvAttributes;
    protected Table tAttributes;
    protected TableViewerColumn tvcAttributesNames;
    protected TableViewerColumn tvcAttributesTypes;
    protected Button btnAddType;
    protected Button btnAddAttribute;
    protected Button btnEditAttribute;
    protected Button btnEditType;
    protected Collection<Object> inputTypes = new ArrayList<Object>();
    protected Collection<Object> inputAttributes = new ArrayList<Object>();
    protected IDataModel selectedModel;
    protected IType selectedType;
    protected IAttribute selectedAttribute;
    private Button btnDeleteAttribute;
    private Button btnDeleteType;
    private Boolean dirty = false;

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        this.inputTypes.clear();
        if (this.tvTypes != null) {
            this.tvTypes.refresh();
        }
        this.inputAttributes.clear();
        if (this.tvAttributes != null) {
            this.tvAttributes.refresh();
        }
    }

    @Override
    public void doCreateContents(Composite control) {
        Group typeGrp = PreferenceUiUtil.createGroup(control, "Data Types");
        this.createTypesUi((Composite)typeGrp);
        Group attributesGrp = PreferenceUiUtil.createGroup(control, "Attributes");
        this.createAttribuesUi((Composite)attributesGrp);
    }

    protected void createAttribuesUi(Composite parent) {
        Composite viewerComposite = new Composite(parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout attributeTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)attributeTVLayout);
        this.tvAttributes = new TableViewer(viewerComposite);
        this.tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tAttributes = this.tvAttributes.getTable();
        this.tAttributes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tAttributes.setHeaderVisible(true);
        this.tAttributes.setLinesVisible(true);
        this.tvcAttributesNames = PreferenceUiUtil.createTableViewerColumn(this.tvAttributes, "Name", 0);
        this.tvcAttributesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAttribute) {
                    return ((IAttribute)element).getName();
                }
                if (element instanceof IEnumerator) {
                    return ((IEnumerator)element).getName();
                }
                return super.getText(element);
            }
        });
        attributeTVLayout.setColumnData((Widget)this.tvcAttributesNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvcAttributesTypes = PreferenceUiUtil.createTableViewerColumn(this.tvAttributes, "Type", 0);
        this.tvcAttributesTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAttribute) {
                    return ((IAttribute)element).getType().getName();
                }
                return "";
            }
        });
        attributeTVLayout.setColumnData((Widget)this.tvcAttributesTypes.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvAttributes.setInput(this.inputAttributes);
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.btnAddAttribute = PreferenceUiUtil.createButton(btnComposite, "Add Attribute", Activator.getImageDescriptor("/icons/add.gif").createImage());
        this.btnAddAttribute.setEnabled(false);
        this.btnEditAttribute = PreferenceUiUtil.createButton(btnComposite, "Edit Attribute", Activator.getImageDescriptor("/icons/edit.png").createImage());
        this.btnEditAttribute.setEnabled(false);
        this.btnDeleteAttribute = PreferenceUiUtil.createButton(btnComposite, "Delete Attribute", Activator.getImageDescriptor("/icons/delete.gif").createImage());
        this.btnDeleteAttribute.setEnabled(false);
    }

    protected void createTypesUi(Composite parent) {
        Composite viewerComposite = new Composite(parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout typesTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)typesTVLayout);
        this.tvTypes = new TableViewer(viewerComposite, 2048);
        this.tvTypes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tTypes = this.tvTypes.getTable();
        this.tTypes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tTypes.setHeaderVisible(true);
        this.tTypes.setLinesVisible(true);
        this.tvcTypesNames = PreferenceUiUtil.createTableViewerColumn(this.tvTypes, "Name", 0);
        this.tvcTypesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IType) {
                    return ((IType)element).getName();
                }
                return super.getText(element);
            }
        });
        typesTVLayout.setColumnData((Widget)this.tvcTypesNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvcTypesTypes = PreferenceUiUtil.createTableViewerColumn(this.tvTypes, "Type", 0);
        this.tvcTypesTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEnumerationType) {
                    return "Enumeration";
                }
                return "Requirement";
            }
        });
        typesTVLayout.setColumnData((Widget)this.tvcTypesTypes.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvTypes.setInput(this.inputTypes);
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.btnAddType = PreferenceUiUtil.createButton(btnComposite, "Add Data Type", Activator.getImageDescriptor("/icons/add.gif").createImage());
        this.btnAddType.setEnabled(false);
        this.btnEditType = PreferenceUiUtil.createButton(btnComposite, "Edit Data Type", Activator.getImageDescriptor("/icons/edit.png").createImage());
        this.btnEditType.setEnabled(false);
        this.btnDeleteType = PreferenceUiUtil.createButton(btnComposite, "Delete Data Type", Activator.getImageDescriptor("/icons/delete.gif").createImage());
        this.btnDeleteType.setEnabled(false);
    }

    @Override
    public void hookListeners() {
        super.hookListeners();
        this.tvModels.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                DataTypesPreferencePage.this.btnAddType.setEnabled(false);
                DataTypesPreferencePage.this.btnAddAttribute.setEnabled(false);
                DataTypesPreferencePage.this.inputTypes.clear();
                DataTypesPreferencePage.this.inputAttributes.clear();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel) {
                    DataTypesPreferencePage.this.selectedModel = (IDataModel)obj;
                    DataTypesPreferencePage.this.btnAddType.setEnabled(true);
                    DataTypesPreferencePage.this.inputTypes.addAll(DataTypesPreferencePage.this.selectedModel.getTypes());
                }
                DataTypesPreferencePage.this.tvTypes.refresh();
                DataTypesPreferencePage.this.tvAttributes.refresh();
            }
        });
        this.tvTypes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                DataTypesPreferencePage.this.btnAddAttribute.setEnabled(false);
                DataTypesPreferencePage.this.btnDeleteType.setEnabled(false);
                DataTypesPreferencePage.this.selectedType = null;
                DataTypesPreferencePage.this.inputAttributes.clear();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IType) {
                    DataTypesPreferencePage.this.selectedType = (IType)obj;
                    DataTypesPreferencePage.this.btnAddAttribute.setEnabled(true);
                    DataTypesPreferencePage.this.btnDeleteType.setEnabled(true);
                    if (obj instanceof IRequirementType) {
                        DataTypesPreferencePage.this.inputAttributes.addAll(((IRequirementType)obj).getAttributes());
                        if (!DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().getResizable()) {
                            int width = DataTypesPreferencePage.this.tvAttributes.getTable().getBounds().width / 2;
                            DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().setWidth(width - DataTypesPreferencePage.this.tvAttributes.getTable().getBorderWidth());
                            DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().setResizable(true);
                            DataTypesPreferencePage.this.tvcAttributesNames.getColumn().setWidth(width - DataTypesPreferencePage.this.tvAttributes.getTable().getBorderWidth());
                        }
                    }
                    if (obj instanceof IEnumerationType) {
                        DataTypesPreferencePage.this.inputAttributes.addAll(((IEnumerationType)obj).getEnumerators());
                        if (DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().getResizable()) {
                            DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().setWidth(0);
                            DataTypesPreferencePage.this.tvcAttributesTypes.getColumn().setResizable(false);
                            DataTypesPreferencePage.this.tvcAttributesNames.getColumn().setWidth(DataTypesPreferencePage.this.tvAttributes.getTable().getBounds().width - DataTypesPreferencePage.this.tvAttributes.getTable().getBorderWidth() * 2);
                        }
                    }
                }
                DataTypesPreferencePage.this.tvAttributes.refresh();
            }
        });
        this.tvAttributes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                DataTypesPreferencePage.this.btnDeleteAttribute.setEnabled(false);
                DataTypesPreferencePage.this.selectedAttribute = null;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IAttribute) {
                    DataTypesPreferencePage.this.selectedAttribute = (IAttribute)obj;
                    DataTypesPreferencePage.this.btnDeleteAttribute.setEnabled(true);
                }
            }
        });
        this.btnAddType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTypeDialog dialog = new AddTypeDialog(e.display.getActiveShell(), "Add Data Type");
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    boolean isReq = dialog.isRequirement();
                    Object type = isReq ? DataTypesPreferencePage.this.dataModelManager.createRequirementType(name, DataTypesPreferencePage.this.selectedModel) : DataTypesPreferencePage.this.dataModelManager.createEnumerationType(name);
                    DataTypesPreferencePage.this.selectedModel.addType((IType)type);
                    DataTypesPreferencePage.this.inputTypes.add(type);
                    DataTypesPreferencePage.this.tvTypes.refresh();
                    DataTypesPreferencePage.this.dirty = true;
                }
            }
        });
        this.btnDeleteType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataTypesPreferencePage.this.selectedType != null && MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)"Delete type", (String)"A new version of the meta model needs to be created when deleting a type, do you confirm ?")) {
                    if (DataTypesPreferencePage.this.selectedType instanceof IRequirementType) {
                        ((IRequirementType)DataTypesPreferencePage.this.selectedType).getAttributes().clear();
                    }
                    DataTypesPreferencePage.this.selectedModel.removeType(DataTypesPreferencePage.this.selectedType);
                    DataTypesPreferencePage.this.inputTypes.remove(DataTypesPreferencePage.this.selectedType);
                    DataTypesPreferencePage.this.tvAttributes.refresh();
                    DataTypesPreferencePage.this.tvTypes.refresh();
                    DataTypesPreferencePage.this.dirty = true;
                }
            }
        });
        this.btnAddAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEnumerator attribute = null;
                if (DataTypesPreferencePage.this.selectedType instanceof IEnumerationType) {
                    NameDialog dialog = new NameDialog(e.display.getActiveShell(), "Add Enumeration Value");
                    if (dialog.open() == 0) {
                        attribute = DataTypesPreferencePage.this.dataModelManager.createEnumerator(dialog.getName());
                        ((IEnumerationType)DataTypesPreferencePage.this.selectedType).addEnumerator(attribute);
                    }
                } else if (DataTypesPreferencePage.this.selectedType instanceof IRequirementType) {
                    HashSet<IType> types = new HashSet<IType>();
                    types.addAll(ETypeImpl.eBasicTypes);
                    types.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)DataTypesPreferencePage.this.selectedModel.getTypes(), (Predicate)new Predicate<IType>(){

                        public boolean apply(IType arg0) {
                            return arg0 instanceof IEnumerationType;
                        }
                    })));
                    AddAttributeDialog dialog = new AddAttributeDialog(e.display.getActiveShell(), "Add Attribute", types);
                    if (dialog.open() == 0) {
                        String name = dialog.getName();
                        IType type = dialog.getType();
                        attribute = DataTypesPreferencePage.this.dataModelManager.createAttribute(name, type, false);
                        ((IRequirementType)DataTypesPreferencePage.this.selectedType).addAttribute((IAttribute)attribute);
                    }
                }
                if (attribute != null) {
                    DataTypesPreferencePage.this.inputAttributes.add(attribute);
                    DataTypesPreferencePage.this.tvAttributes.refresh();
                    DataTypesPreferencePage.this.dirty = true;
                }
            }
        });
        this.btnDeleteAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataTypesPreferencePage.this.selectedAttribute != null && DataTypesPreferencePage.this.selectedType instanceof IRequirementType && MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)"Delete type", (String)"A new version of the meta model needs to be created when deleting an attribute, do you confirm ?")) {
                    ((IRequirementType)DataTypesPreferencePage.this.selectedType).removeAttribute(DataTypesPreferencePage.this.selectedAttribute);
                    DataTypesPreferencePage.this.inputAttributes.remove(DataTypesPreferencePage.this.selectedAttribute);
                    DataTypesPreferencePage.this.tvAttributes.refresh();
                    DataTypesPreferencePage.this.dirty = true;
                }
            }
        });
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        if (this.dirty.booleanValue()) {
            this.tvModels.refresh();
            this.btnAddType.setEnabled(false);
            this.btnAddAttribute.setEnabled(false);
            this.inputTypes.clear();
            if (this.tvTypes != null) {
                this.tvTypes.refresh();
            }
            this.inputAttributes.clear();
            if (this.tvAttributes != null) {
                this.tvAttributes.refresh();
            }
            this.dirty = false;
        }
        return result;
    }
}

