/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.preference.pages;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.Activator;
import org.polarsys.reqcycle.repository.data.ui.dialog.NameDialog;
import org.polarsys.reqcycle.repository.data.ui.preference.PreferenceUiUtil;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DataModelsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    @Inject
    IDataModelManager dataModelManager;
    protected TableViewer tvModels;
    protected Table tModels;
    protected Button btnAddModel;
    protected Button btnEditModel;
    protected Button btnDeleteModel;
    protected Collection<IDataModel> inputModels;
    @Inject
    private IDataManager dataManager;

    public DataModelsPreferencePage() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected void performDefaults() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button defaultButton = this.getDefaultsButton();
        if (defaultButton != null) {
            defaultButton.setVisible(false);
            defaultButton.setEnabled(false);
        }
    }

    public boolean performOk() {
        this.dataModelManager.save();
        boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Eclipse Restart needed", (String)"A restart of Eclipse is needed to handle requirement data model changes.\nDo you want to restart now ?");
        if (res) {
            PlatformUI.getWorkbench().restart();
        }
        return true;
    }

    public boolean performCancel() {
        this.dataModelManager.discardUnsavedChanges();
        return super.performCancel();
    }

    protected Control createContents(Composite parent) {
        SashForm control = new SashForm(parent, 512);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData());
        Group packagesGrp = PreferenceUiUtil.createGroup((Composite)control, "Data Models");
        this.createModelsUi((Composite)packagesGrp);
        this.doCreateContents((Composite)control);
        this.hookListeners();
        return control;
    }

    public void doCreateContents(Composite control) {
    }

    protected void createModelsUi(Composite parent) {
        Composite viewerComposite = new Composite(parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout packagesTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)packagesTVLayout);
        this.tvModels = this.createDataModelTableViewer(viewerComposite, packagesTVLayout);
        this.tModels = this.tvModels.getTable();
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.btnAddModel = PreferenceUiUtil.createButton(btnComposite, "Add Data Model", Activator.getImageDescriptor("/icons/add.gif").createImage());
        this.btnEditModel = PreferenceUiUtil.createButton(btnComposite, "Edit Data Model", Activator.getImageDescriptor("/icons/edit.png").createImage());
        this.btnEditModel.setEnabled(false);
        this.btnDeleteModel = PreferenceUiUtil.createButton(btnComposite, "Delete Data Model", Activator.getImageDescriptor("/icons/delete.gif").createImage());
    }

    public TableViewer createDataModelTableViewer(Composite parent, TableColumnLayout packagesTVLayout) {
        TableViewer tvModels = new TableViewer(parent);
        tvModels.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tModels = tvModels.getTable();
        tModels.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tModels.setLinesVisible(true);
        TableViewerColumn tvcModelsNames = PreferenceUiUtil.createTableViewerColumn(tvModels, "Name", 0);
        tvcModelsNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDataModel) {
                    IDataModel dataModel = (IDataModel)element;
                    return String.valueOf(dataModel.getName()) + (dataModel.getVersion() > 1 ? " (v" + dataModel.getVersion() + ")" : "");
                }
                return super.getText(element);
            }
        });
        packagesTVLayout.setColumnData((Widget)tvcModelsNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.initInput(this.dataModelManager);
        tvModels.setInput(this.inputModels);
        return tvModels;
    }

    private void initInput(IDataModelManager dataModelManager) {
        this.inputModels = new ArrayList<IDataModel>();
        this.inputModels.addAll(dataModelManager.getCurrentDataModels());
    }

    public void addDataModels(IDataModel ... models) {
        IDataModel[] iDataModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModel model = iDataModelArray[n2];
            this.inputModels.add(model);
            ++n2;
        }
    }

    public void removeDataModels(IDataModel ... models) {
        IDataModel[] iDataModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModel model = iDataModelArray[n2];
            this.inputModels.remove(model);
            ++n2;
        }
    }

    private <T extends EObject> T resolveProxy(T obj) {
        if (obj.eIsProxy() && obj.eResource() != null) {
            EObject newObj = EcoreUtil.resolve(obj, (ResourceSet)obj.eResource().getResourceSet());
            return (T)newObj;
        }
        return obj;
    }

    private boolean isTypesUsed(Collection<EClass> types) {
        Iterator iterator = this.dataManager.getRequirementSources().iterator();
        if (iterator.hasNext()) {
            RequirementSource requirementSource = (RequirementSource)iterator.next();
            requirementSource = this.resolveProxy(requirementSource);
            return this.isRequirementTypesUsed((EList<AbstractElement>)requirementSource.getRequirements(), types);
        }
        return false;
    }

    private boolean isRequirementTypesUsed(EList<AbstractElement> requirements, Collection<EClass> types) {
        for (AbstractElement abstractElement : requirements) {
            if (types.contains((abstractElement = this.resolveProxy(abstractElement)).eClass())) {
                return true;
            }
            if (abstractElement != null && abstractElement.getScopes() != null && !abstractElement.getScopes().isEmpty()) {
                for (Scope scope : abstractElement.getScopes()) {
                    scope = this.resolveProxy(scope);
                }
            }
            if (!(abstractElement instanceof Requirement)) continue;
            return this.isRequirementTypesUsed((EList<AbstractElement>)((Requirement)abstractElement).getChildren(), types);
        }
        return false;
    }

    public boolean isDataModelUsed(IDataModel dataModel) {
        Collection types = dataModel.getTypes();
        Collection eTypes = Collections2.transform((Collection)types, (Function)new Function<IType, EClass>(){

            public EClass apply(IType type) {
                EClass eclass = null;
                if (type instanceof IAdaptable) {
                    eclass = (EClass)((IAdaptable)type).getAdapter(EClass.class);
                }
                return eclass;
            }
        });
        if (this.isTypesUsed(Collections2.filter((Collection)eTypes, (Predicate)Predicates.notNull()))) {
            return true;
        }
        String dataModelURI = dataModel.getDataModelURI();
        Set sources = this.dataManager.getRequirementSources();
        for (RequirementSource requirementSource : sources) {
            if (!dataModelURI.equals(requirementSource.getDataModelURI())) continue;
            return true;
        }
        for (Scope scope : this.dataModelManager.getScopes(dataModel)) {
            EList reqs = scope.getRequirements();
            if (reqs == null || reqs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void hookListeners() {
        this.btnAddModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NameDialog dialog = new NameDialog(e.display.getActiveShell(), "Add Data Model"){

                    protected void okPressed() {
                        String name = this.getName();
                        if ((this).DataModelsPreferencePage.this.dataModelManager.getCurrentDataModel(name) != null) {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Add Data Model", (String)"A Data Model with the same name already exists. Please choose a differente one.");
                            return;
                        }
                        super.okPressed();
                    }
                };
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    DataModelsPreferencePage.this.addDataModels(DataModelsPreferencePage.this.dataModelManager.createDataModel(name));
                    DataModelsPreferencePage.this.tvModels.refresh();
                }
            }
        });
        this.btnDeleteModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstElement;
                ISelection selection = DataModelsPreferencePage.this.tvModels.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel) {
                    IDataModel dataModel = (IDataModel)firstElement;
                    if (!DataModelsPreferencePage.this.isEmpty(dataModel) && !MessageDialog.openQuestion((Shell)DataModelsPreferencePage.this.getShell(), (String)"Delete Data Model", (String)"The Data Model you are trying to remove is not empty. Would you like to continue ?")) {
                        return;
                    }
                    if (DataModelsPreferencePage.this.isUsed(dataModel).booleanValue()) {
                        MessageDialog.openError((Shell)DataModelsPreferencePage.this.getShell(), (String)"Delete Data Model", (String)"The Data Model you are trying to remove is used. Used Data Models can't be deleted");
                        return;
                    }
                    DataModelsPreferencePage.this.removeDataModels(dataModel);
                    DataModelsPreferencePage.this.dataModelManager.removeDataModel(dataModel);
                    DataModelsPreferencePage.this.tvModels.refresh();
                }
            }
        });
    }

    protected boolean isEmpty(IDataModel dataModel) {
        return this.dataModelManager.isEmpty(dataModel);
    }

    protected Boolean isUsed(IDataModel dataModel) {
        return this.isDataModelUsed(dataModel);
    }

    public void handleEvent(Event event) {
        if (this.tvModels != null) {
            this.tvModels.refresh();
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        if (visible && this.tvModels != null && this.inputModels != null) {
            Collection dataModels = this.dataModelManager.getCurrentDataModels();
            Iterator<IDataModel> iter = this.inputModels.iterator();
            ArrayList<IDataModel> toRemove = new ArrayList<IDataModel>();
            while (iter.hasNext()) {
                IDataModel dataModel = iter.next();
                if (dataModels.contains(dataModel)) continue;
                toRemove.add(dataModel);
            }
            this.removeDataModels(toRemove.toArray(new IDataModel[toRemove.size()]));
            this.tvModels.refresh();
        }
        super.setVisible(visible);
    }
}

