/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.local;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementSourceDataPackage;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqCycleContributionItem
extends CompoundContributionItem {
    @Inject
    IDataModelManager dataModelManager;
    @Inject
    IDataManager dataManager;
    protected EObject selectedElement;

    public ReqCycleContributionItem() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected IContributionItem[] getContributionItems() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Set<Object> classes = new HashSet();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            this.selectedElement = null;
            if (firstElement instanceof EObject) {
                this.selectedElement = (EObject)firstElement;
                classes = this.getDataEClasses(this.selectedElement);
            }
        }
        Collection menuContributionList = Collections2.transform(classes, (Function)new Function<EClass, IContributionItem>(){

            public IContributionItem apply(final EClass arg0) {
                ContributionItem contributionItem = new ContributionItem(){

                    public void fill(Menu menu, int index) {
                        MenuItem menuItem = new MenuItem(menu, 0);
                        menuItem.setText(arg0.getName());
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                try {
                                    EObject object = arg0.getEPackage().getEFactoryInstance().create(arg0);
                                    if (!(object instanceof AbstractElement)) {
                                        throw new Exception("Error while creating a " + arg0.getName() + " element.");
                                    }
                                    AbstractElement element = (AbstractElement)object;
                                    if (((this).this).ReqCycleContributionItem.this.selectedElement instanceof RequirementSource) {
                                        ((this).this).ReqCycleContributionItem.this.dataManager.addElementsToSource((RequirementSource)((this).this).ReqCycleContributionItem.this.selectedElement, new AbstractElement[]{element});
                                    }
                                    if (((this).this).ReqCycleContributionItem.this.selectedElement instanceof Section) {
                                        ((this).this).ReqCycleContributionItem.this.dataManager.addElementsToSection((Section)((this).this).ReqCycleContributionItem.this.selectedElement, new AbstractElement[]{element});
                                    }
                                    ((this).this).ReqCycleContributionItem.this.dataManager.notifyChange("TOPIC_REQCYCLE_DATA/NEW/ELEMENT/*", (Object)element);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                    }
                };
                return contributionItem;
            }
        });
        IContributionItem[] array = new IContributionItem[menuContributionList.size()];
        return menuContributionList.toArray(array);
    }

    protected Set<EClass> getDataEClasses(Object selectedElement) {
        if (!(selectedElement instanceof Section) && !(selectedElement instanceof RequirementSource)) {
            return Sets.newHashSet();
        }
        HashSet<EClass> classes = new HashSet<EClass>();
        Collection dataModels = this.dataModelManager.getCurrentDataModels();
        ArrayList types = Lists.newArrayList();
        for (IDataModel dataModel : dataModels) {
            types.addAll(dataModel.getTypes());
        }
        classes.addAll(Collections2.transform((Collection)types, (Function)new Function<IType, EClass>(){

            public EClass apply(IType arg0) {
                if (arg0 instanceof IAdaptable) {
                    return (EClass)((IAdaptable)arg0).getAdapter(EClass.class);
                }
                return null;
            }
        }));
        classes.add(RequirementSourceDataPackage.Literals.SECTION);
        return classes;
    }
}

