/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document.ocl;

import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.reqcycle.ocl.ui.OCLConnector;
import org.polarsys.reqcycle.ocl.ui.OCLPage;
import org.polarsys.reqcycle.ocl.ui.SettingBean;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.IURIValidatorConnector;
import org.polarsys.reqcycle.repository.connector.document.ocl.DocOclCallable;
import org.polarsys.reqcycle.repository.connector.document.ocl.ui.DocOclSettingPage;
import org.polarsys.reqcycle.repository.connector.document.ocl.ui.OCLDocBean;
import org.polarsys.reqcycle.repository.connector.ui.wizard.IConnectorWizard;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocOclConnector
extends Wizard
implements IConnectorWizard,
IURIValidatorConnector {
    protected DocOclSettingPage docOclSettingPage;
    protected OCLPage oclMappingPage;
    private SettingBean bean;
    private RequirementSource requirementSource = null;
    @Inject
    IDataModelManager manager;
    @Inject
    IDataManager dataManager;
    OCLConnector OCLConnector = new OCLConnector();

    public void addPages() {
        this.bean = new OCLDocBean((IWizard)this.OCLConnector);
        this.docOclSettingPage = new DocOclSettingPage(this.bean);
        this.oclMappingPage = new OCLPage(this.bean);
        this.addPage((IWizardPage)this.docOclSettingPage);
        this.addPage((IWizardPage)this.oclMappingPage);
        super.addPages();
    }

    public ICallable getRequirementsCreator() {
        DocOclCallable callable = new DocOclCallable();
        ZigguratInject.inject((Object[])new Object[]{callable});
        return callable;
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        return this.bean != null && this.bean.getOclUri() != null && this.bean.getDataModel() != null && this.bean.getUri() != null && !this.bean.getOclUri().isEmpty() && !this.bean.getUri().isEmpty() && !this.bean.getOutputPath().isEmpty();
    }

    public void initializeWithRequirementSource(RequirementSource requirementSource) {
        this.requirementSource = requirementSource;
    }

    public void init(ISelection selection, String name) {
    }

    public void storeProperties(RequirementSource source) {
        this.bean.storeProperties(source);
    }

    public IStatus validate(URI uri) {
        Doc2Model doc2Model = new Doc2Model();
        String fileString = CommonPlugin.asLocalURI((URI)uri).toFileString();
        String fileType = doc2Model.getFileType(fileString);
        if (fileType.toString() != null) {
            return Status.OK_STATUS;
        }
        String extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length());
        return new Status(2, "org.polarsys.reqcycle.repository.connector.document.using.ocl", "extension " + extension + " is not supported. Retry and choose document file");
    }
}

