/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.reqcycle.inittypes.inittypes.FileType;
import org.polarsys.reqcycle.inittypes.inittypes.Requirement;
import org.polarsys.reqcycle.inittypes.inittypes.Type;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.IURIValidatorConnector;
import org.polarsys.reqcycle.repository.connector.document.DocCallable;
import org.polarsys.reqcycle.repository.connector.document.DocUtils;
import org.polarsys.reqcycle.repository.connector.document.ui.DocMappingPage;
import org.polarsys.reqcycle.repository.connector.document.ui.DocSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.connector.ui.wizard.IConnectorWizard;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocConnector
extends Wizard
implements IConnectorWizard,
IURIValidatorConnector {
    protected DocSettingPage docSettingPage;
    protected DocMappingPage docMappingPage;
    protected List<Type> listTypes;
    protected boolean edition = false;
    protected RequirementSource initSource;
    protected DOCSettingBean bean;
    protected URI initFileUri;
    @Inject
    IDataManager dataManager;

    public void initializeWithRequirementSource(RequirementSource requirementSource) {
        this.initSource = requirementSource;
        this.edition = true;
    }

    public void addPages() {
        this.bean = new DOCSettingBean();
        this.docSettingPage = new DocSettingPage(this.bean);
        this.docMappingPage = new DocMappingPage(this.bean);
        this.addPage((IWizardPage)this.docSettingPage);
        this.addPage((IWizardPage)this.docMappingPage);
        super.addPages();
    }

    public ICallable getRequirementsCreator() {
        DocCallable callable = (DocCallable)ZigguratInject.make(DocCallable.class);
        return callable;
    }

    public void init(ISelection selection, String name) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.initFileUri = URI.createPlatformResourceURI((String)((IFile)obj).getFullPath().toPortableString(), (boolean)true);
        }
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        if (this.docMappingPage != null && this.bean.getListType() != null && this.bean.getListType().size() > 0) {
            return this.docMappingPage.isPageComplete();
        }
        return false;
    }

    public void storeProperties(RequirementSource source) {
        this.bean.storeProperties(source);
        Collection<Object> mapElements = new ArrayList();
        if (this.bean.getListValideRequirements() != null) {
            mapElements = DocUtils.mappingElements(this.bean.getListValideRequirements(), PropertyUtils.getDataModelFromSource((RequirementSource)source).getTypes());
        }
        source.getMappings().addAll(mapElements);
    }

    public IStatus validate(URI uri) {
        Doc2Model doc2Model = new Doc2Model();
        String fileString = CommonPlugin.asLocalURI((URI)uri).toFileString();
        String fileType = doc2Model.getFileType(fileString);
        if (fileType != null && fileType.toString() != null) {
            return Status.OK_STATUS;
        }
        String extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length());
        return new Status(2, "org.polarsys.reqcycle.repository.connector.document", "extension \"" + extension + "\" is not supported. Retry and choose document file");
    }

    public class DOCSettingBean
    extends AbstractStorageBean {
        private List<Requirement> listSelectedRequirements = new ArrayList<Requirement>();
        private Type type;
        private List<Type> listType = null;
        private FileType fileType;

        public FileType getFileType() {
            return this.fileType;
        }

        public void setFileType(FileType fileType) {
            this.fileType = fileType;
        }

        public List<Type> getListType() {
            return this.listType;
        }

        public void setListType(List<Type> listType) {
            this.listType = listType;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public List<Requirement> getListValideRequirements() {
            return this.listSelectedRequirements;
        }

        public void setListValideRequirements(List<Requirement> listSelectedRequirements) {
            this.listSelectedRequirements = listSelectedRequirements;
        }

        public void storeProperties(RequirementSource source) {
            super.storeProperties(source);
            try {
                source.setProperty("org.polarsys.reqcycle.repository.connector.document.doc.name", this.getType().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

