/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttributeType implements Enumerator
{
    STRING(0, "String", "String"),
    BOOLEAN(1, "Boolean", "Boolean"),
    INT(2, "Int", "Int");

    public static final int STRING_VALUE = 0;
    public static final int BOOLEAN_VALUE = 1;
    public static final int INT_VALUE = 2;
    private static final AttributeType[] VALUES_ARRAY;
    public static final List<AttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeType[]{STRING, BOOLEAN, INT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return INT;
            }
        }
        return null;
    }

    private AttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

