/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.storage.IStoragePathProvider;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.utils.ManageTraceabilityUtils;
import org.polarsys.reqcycle.traceability.table.model.LinkRow;
import org.polarsys.reqcycle.traceability.table.providers.TraceabilityLazyContentProvider;
import org.polarsys.reqcycle.traceability.types.scopes.ConfigurationScope;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

public class TableController {
    @Inject
    protected IStorageProvider storageProvider;
    @Inject
    protected IStoragePathProvider storagePathProvider;
    @Inject
    protected IReachableListenerManager listenerManager;
    @Inject
    protected ITraceabilityEngine engine;
    protected TableViewer viewer;
    protected Callable<Iterable<?>> callable;

    public TableController(TableViewer viewer) {
        this.viewer = viewer;
    }

    public void displayAllLinks() {
        this.callable = new Callable<Iterable<?>>(){

            @Override
            public Iterable<?> call() throws Exception {
                return TableController.this.getLinksFromEngine();
            }
        };
        this.refreshViewerData();
    }

    protected Iterable<Link> getLinksFromEngine() {
        return new Iterable<Link>(){

            @Override
            public Iterator<Link> iterator() {
                Request request = new Request();
                CompositeScope scope = new CompositeScope();
                scope.add(Scopes.getWorkspaceScope());
                scope.add((IScope)new ConfigurationScope());
                request.setScope((IScope)scope);
                request.setDepth(Request.DEPTH.INFINITE);
                try {
                    Iterator traceability = TableController.this.engine.getTraceability(new Request[]{request});
                    return Iterators.transform((Iterator)traceability, (Function)new Function<Pair<Link, Reachable>, Link>(){

                        public Link apply(Pair<Link, Reachable> arg0) {
                            return (Link)arg0.getFirst();
                        }
                    });
                }
                catch (EngineException e) {
                    e.printStackTrace();
                    return new ArrayList().iterator();
                }
            }
        };
    }

    public void deleteExplicitTraceabilityLinks(Iterator<LinkRow> linkRows) {
        Iterator<LinkRow> it = linkRows;
        while (it.hasNext()) {
            ManageTraceabilityUtils.deleteTraceabilityLink((Link)it.next().getLink(), (IStorageProvider)this.storageProvider, (IStoragePathProvider)this.storagePathProvider, (IReachableListenerManager)this.listenerManager);
        }
        this.refreshViewerData();
    }

    public void refreshViewerData() {
        Predicate<Object> filter = new Predicate<Object>(){

            public boolean apply(Object arg0) {
                ViewerFilter[] filters = TableController.this.viewer.getFilters();
                int i = 0;
                while (i < filters.length) {
                    ViewerFilter filter = filters[i];
                    if (!filter.select((Viewer)TableController.this.viewer, null, arg0)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        try {
            Iterable<?> input = this.callable.call();
            Iterable filtered = Iterables.filter(input, (Predicate)filter);
            int count = Iterables.size((Iterable)filtered);
            this.viewer.setItemCount(count);
            LinkedList<LinkRow> filteredRows = new LinkedList<LinkRow>();
            for (Object o : filtered) {
                if (!(o instanceof Link)) continue;
                Link l = (Link)o;
                filteredRows.add(new LinkRow(l));
            }
            this.viewer.setInput(filteredRows);
            this.viewer.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshViewerVisuals() {
        TraceabilityLazyContentProvider contentProvider = (TraceabilityLazyContentProvider)this.viewer.getContentProvider();
        this.viewer.setItemCount(Iterables.size((Iterable)((Iterable)this.viewer.getInput())));
        contentProvider.clearCache();
        this.viewer.refresh();
    }
}

