/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.filters;

import com.google.common.collect.Iterables;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.uri.model.Reachable;

public class TableFilter
extends ViewerFilter {
    private String searchString;

    public void setSearchText(String s) {
        this.searchString = ".*" + s + ".*";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchString == null || this.searchString.length() == 0) {
            return true;
        }
        Link link = (Link)element;
        Reachable source = (Reachable)Iterables.get((Iterable)link.getSources(), (int)0);
        String sourceText = TraceabilityUtils.getText((Reachable)source);
        Reachable target = (Reachable)Iterables.get((Iterable)link.getTargets(), (int)0);
        String targetText = TraceabilityUtils.getText((Reachable)target);
        if (link.getKind().getLabel().matches(this.searchString)) {
            return true;
        }
        if (sourceText != null && sourceText.matches(this.searchString)) {
            return true;
        }
        return targetText != null && targetText.matches(this.searchString);
    }
}

