/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.merge;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.polarsys.reqcycle.impact.merge.StatusUtil;

public class ExceptionWithStatus
extends Exception
implements IAdaptable {
    private static final long serialVersionUID = 474407109912835365L;
    private IStatus status;

    public ExceptionWithStatus(IStatus status) {
        super(StatusUtil.getStatusMessage(status, null));
        this.status = status;
    }

    public ExceptionWithStatus(IStatus status, Throwable cause) {
        super(StatusUtil.getStatusMessage(status, null), cause);
        this.status = status;
    }

    public ExceptionWithStatus(String message) {
        super(message);
    }

    public ExceptionWithStatus(String message, Throwable cause) {
        super(message, cause);
        this.handleCause(cause);
    }

    public ExceptionWithStatus(Throwable cause) {
        super(cause);
        this.handleCause(cause);
    }

    protected void handleCause(Throwable cause) {
        Object possibleStatus;
        if (cause instanceof IAdaptable && (possibleStatus = ((IAdaptable)cause).getAdapter(IStatus.class)) instanceof IStatus) {
            this.status = (IStatus)possibleStatus;
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Object getAdapter(Class adapter) {
        if (IStatus.class.isAssignableFrom(adapter)) {
            return this.status;
        }
        return null;
    }
}

