/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.collect.collectors;

import org.polarsys.reqcycle.utils.collect.Picker;
import org.polarsys.reqcycle.utils.collect.ResultHandler;
import org.polarsys.reqcycle.utils.collect.collectors.AbstractCollector;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.collect.exceptions.CollectionAbortedException;

public class DepthCollector<T>
extends AbstractCollector<T> {
    public DepthCollector(T startingElement, Iterable<? extends Picker<T>> pickers) {
        super(startingElement, pickers);
    }

    @Override
    public void collect(ResultHandler<T> handler) throws CollectionAbortedException {
        this.collectDepthWise(handler, this.start);
    }

    protected void collectDepthWise(ResultHandler<T> handler, T element) throws CollectionAbortedException {
        try {
            handler.handleResult(element);
            for (Picker<T> picker : this.getPickers()) {
                Iterable nexts = picker.getNexts(element);
                if (nexts == null) continue;
                for (Object next : nexts) {
                    this.collectDepthWise(handler, next);
                }
            }
        }
        catch (CannotHandleException cannotHandleException) {
        }
        catch (Exception e) {
            throw new CollectionAbortedException(e);
        }
    }
}

