/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.collect;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import org.polarsys.reqcycle.utils.collect.Picker;
import org.polarsys.reqcycle.utils.collect.collectors.DepthCollector;
import org.polarsys.reqcycle.utils.collect.collectors.WidthCollector;
import org.polarsys.reqcycle.utils.collect.yieldadapters.ThreadedYieldAdapter;

public class IterableFactory {
    public static <T> Iterable<T> createIterable(T startingElement, Iterable<? extends Picker<T>> pickers) {
        DepthCollector<T> collector = new DepthCollector<T>(startingElement, pickers);
        ThreadedYieldAdapter<T> yieldAdapter = new ThreadedYieldAdapter<T>();
        return yieldAdapter.adapt(collector);
    }

    public static <T> Iterable<T> createIterable(T startingElement, Picker<T> ... pickers) {
        DepthCollector<T> collector = new DepthCollector<T>(startingElement, Arrays.asList(pickers));
        ThreadedYieldAdapter<T> yieldAdapter = new ThreadedYieldAdapter<T>();
        return yieldAdapter.adapt(collector);
    }

    public static <T> Iterable<T> createIterable(Iterable<T> startingElements, Iterable<? extends Picker<T>> pickers) {
        Iterable<Object> result = Collections.emptyList();
        for (T t : startingElements) {
            Iterable<T> tIterable = IterableFactory.createIterable(t, pickers);
            result = Iterables.concat(result, tIterable);
        }
        return result;
    }

    public static <T> Iterable<T> createIterable(Iterable<T> startingElements, Picker<T> picker) {
        Iterable<Object> result = Collections.emptyList();
        for (T t : startingElements) {
            Iterable<T> tIterable = IterableFactory.createIterable(t, Collections.singleton(picker));
            result = Iterables.concat(result, tIterable);
        }
        return result;
    }

    public static <T> Iterable<T> createIterable(Iterable<T> startingElements, Picker<T> ... pickers) {
        Iterable<Object> result = Collections.emptyList();
        for (T t : startingElements) {
            Iterable<T> tIterable = IterableFactory.createIterable(t, pickers);
            result = Iterables.concat(result, tIterable);
        }
        return result;
    }

    public static <T> Iterable<T> createWidthWiseIterable(T startingElement, Iterable<? extends Picker<T>> pickers) {
        WidthCollector<T> collector = new WidthCollector<T>(startingElement, pickers);
        ThreadedYieldAdapter<T> yieldAdapter = new ThreadedYieldAdapter<T>();
        return yieldAdapter.adapt(collector);
    }

    public static <T> Iterable<T> createWidthWiseIterable(T startingElement, Picker<T> ... pickers) {
        WidthCollector<T> collector = new WidthCollector<T>(startingElement, Arrays.asList(pickers));
        ThreadedYieldAdapter<T> yieldAdapter = new ThreadedYieldAdapter<T>();
        return yieldAdapter.adapt(collector);
    }

    public static <T> Iterable<T> createWidthWiseIterable(Iterable<T> startingElements, Iterable<? extends Picker<T>> pickers) {
        WidthCollector<T> collector = new WidthCollector<T>(startingElements, pickers);
        ThreadedYieldAdapter<T> yieldAdapter = new ThreadedYieldAdapter<T>();
        return yieldAdapter.adapt(collector);
    }
}

