/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.reqcycle.traceability.builder.BuilderUtil;

public class TraceabilityBuildersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        c.setLayout((Layout)new GridLayout(1, false));
        Label lblTheCheckedProjects = new Label(c, 0);
        lblTheCheckedProjects.setText("The checked projects will be analyzed by ReqCycle traceability engine");
        CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)c, (int)2048);
        Table table = checkboxTableViewer.getTable();
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        checkboxTableViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        checkboxTableViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return BuilderUtil.isBuilderInstalled((IProject)project);
                }
                return false;
            }
        });
        checkboxTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IProject && ((IProject)element).isAccessible();
            }
        });
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (event.getChecked()) {
                        BuilderUtil.installBuilder((IProject)project);
                    } else {
                        BuilderUtil.removeBuilder((IProject)project);
                    }
                }
            }
        });
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return parent;
    }
}

