/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.utils.LazyMap;
import org.polarsys.reqcycle.uri.model.Reachable;

public class EngineUtils {
    public static Multimap<Reachable, Link> toFollowingMap(Iterator<Pair<Link, Reachable>> resultOfEngine) {
        HashMultimap result = HashMultimap.create();
        while (resultOfEngine.hasNext()) {
            Pair<Link, Reachable> next = resultOfEngine.next();
            Reachable source = next.getFirst().getSources().iterator().next();
            result.put((Object)source, (Object)next.getFirst());
        }
        return result;
    }

    public static Multimap<Reachable, Link> toPrecedingMap(Iterator<Pair<Link, Reachable>> resultOfEngine) {
        HashMultimap result = HashMultimap.create();
        while (resultOfEngine.hasNext()) {
            Pair<Link, Reachable> next = resultOfEngine.next();
            result.put((Object)next.getFirst().getTargets().iterator().next(), (Object)next.getFirst());
        }
        return result;
    }

    public static Multimap<Reachable, Link> toFollowingLazyMap(Iterator<Pair<Link, Reachable>> resultOfEngine) {
        LazyMap map = new LazyMap(resultOfEngine);
        return map;
    }
}

