/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.storage.IOneFileStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.uri.functions.URIFunctions;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilitySynchronizer {
    private static final String RDF_FILE = "./.traceability.rdf";
    @Inject
    @Named(value="RDF")
    protected IOneFileStorageProvider provider;
    protected final IFile file;

    public TraceabilitySynchronizer(IProject project) {
        this.file = project.getFile((IPath)new Path(RDF_FILE));
    }

    public IFile getFile() {
        return this.file;
    }

    public Iterable<Link> getTraceabilityLinks(IProject project) {
        IFile file = project.getFile((IPath)new Path(RDF_FILE));
        if (file != null && file.exists()) {
            String uri = file.getLocationURI().getPath();
            ZigguratInject.inject((Object[])new Object[]{this.provider});
            ITraceabilityStorage storage = this.provider.getStorage(uri);
            Iterable allTraceabilityLinks = storage.getAllTraceability(ITraceabilityEngine.DIRECTION.DOWNWARD);
            return Iterables.transform((Iterable)allTraceabilityLinks, (Function)new Function<Pair<Link, Reachable>, Link>(){

                public Link apply(Pair<Link, Reachable> arg0) {
                    return (Link)arg0.getFirst();
                }
            });
        }
        return Lists.newArrayList();
    }

    public Iterable<Link> getTraceabilityLinks(InputStream inputStream) {
        ITraceabilityStorage storage = this.provider.getStorageReader(inputStream);
        Iterable allTraceabilityLinks = storage.getAllTraceability(ITraceabilityEngine.DIRECTION.DOWNWARD);
        return Iterables.transform((Iterable)allTraceabilityLinks, (Function)new Function<Pair<Link, Reachable>, Link>(){

            public Link apply(Pair<Link, Reachable> arg0) {
                return (Link)arg0.getFirst();
            }
        });
    }

    public void addNewLinks(IFile rdfFile, Collection<Link> newLinks) {
        String uri = rdfFile.getLocationURI().getPath();
        ZigguratInject.inject((Object[])new Object[]{this.provider});
        ITraceabilityStorage storage = this.provider.getStorage(uri);
        for (Link link : newLinks) {
            Set targets = link.getTargets();
            Reachable[] sources = link.getSources().toArray(new Reachable[link.getSources().size()]);
            Reachable target = null;
            if (targets.size() > 0) {
                target = (Reachable)targets.iterator().next();
            }
            Function obj2RO = URIFunctions.newObject2ReachableFunction();
            Reachable resourceReachable = (Reachable)obj2RO.apply((Object)rdfFile);
            storage.addOrUpdateUpwardRelationShip(link.getKind(), link.getId(), resourceReachable, target, sources);
        }
        storage.save();
    }
}

