/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.commands.utils;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;

public class RelationCreationDescriptor {
    private int type;
    private Relation relation;
    public static final int DOWNSTREAM_TO_UPSTREAM = -1;
    public static final int UPSTREAM_TO_DOWNSTREAM = 1;
    public static final int BOTH = 0;
    private AdapterFactoryLabelProvider labelProvider;

    public RelationCreationDescriptor(int type, Relation relation) {
        this.type = type;
        this.relation = relation;
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
    }

    public Relation getRelation() {
        return this.relation;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationCreationDescriptor other = (RelationCreationDescriptor)obj;
        if (this.relation == null ? other.relation != null : !this.relation.equals(other.relation)) {
            return false;
        }
        return this.type == other.type;
    }

    public Type getSource() {
        if (this.isDownstreamToUpstream()) {
            return this.relation.getDownstreamType();
        }
        return this.relation.getUpstreamType();
    }

    public Type getTarget() {
        if (this.isDownstreamToUpstream()) {
            return this.relation.getUpstreamType();
        }
        return this.relation.getDownstreamType();
    }

    public String getLabel() {
        StringBuilder labelBuilder = new StringBuilder(this.relation.getKind().toUpperCase());
        if (this.type == 1 || this.type == 0) {
            labelBuilder.append(" - FROM " + this.labelProvider.getText((Object)this.relation.getUpstreamType()));
            labelBuilder.append(" TO " + this.labelProvider.getText((Object)this.relation.getDownstreamType()));
        } else {
            labelBuilder.append(" - FROM " + this.labelProvider.getText((Object)this.relation.getDownstreamType()));
            labelBuilder.append(" TO " + this.labelProvider.getText((Object)this.relation.getUpstreamType()));
        }
        return labelBuilder.toString();
    }

    public boolean isDownstreamToUpstream() {
        return this.type == -1 || this.type == 0;
    }

    public boolean isUpstreamToDownstream() {
        return this.type == 1 || this.type == 0;
    }
}

