/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.tika.parser.microsoft.Cell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.CellsGroup;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.EmptyCell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SpreadSheetElement;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.StylizedCell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRow;

public class Table
implements Iterable<SubRow>,
SpreadSheetElement {
    private String _title = "";
    private List<SubRow> _rows = new ArrayList<SubRow>();
    private int _maxHiearchy = 0;
    private SubRow _header;

    public Table(SubRow subrow) {
        this._rows.add(subrow);
    }

    public SubRow getHeader() {
        return this._header;
    }

    public void setHeader(SubRow sub) {
        this._header = sub;
    }

    public boolean isEmpty() {
        return this._rows.isEmpty();
    }

    public List<SubRow> getRows() {
        return this._rows;
    }

    public int getFirstRowIndex() {
        return this._rows.get(0).getRowIndex();
    }

    public int getLastRowIndex() {
        return this._rows.get(this._rows.size() - 1).getRowIndex();
    }

    public SubRow getLastSubRow() {
        return this._rows.get(this._rows.size() - 1);
    }

    public int getNbRows() {
        return this._rows.size();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public Iterator<SubRow> iterator() {
        return this._rows.iterator();
    }

    public void addSubRow(SubRow subrow) {
        this._rows.add(subrow);
    }

    public void setMaxHiearchy(int hiearchy) {
        this._maxHiearchy = hiearchy;
    }

    public int getMaxHiearchy() {
        return this._maxHiearchy;
    }

    public Cell[][] finalizeTable() {
        Cell[][] returnTable = new Cell[this._rows.size() + 1][this._header.getNbColumn()];
        int i = 0;
        while (i < this._rows.size() + 1) {
            int j = 0;
            while (j < this._header.getNbColumn()) {
                returnTable[i][j] = new EmptyCell();
                ++j;
            }
            ++i;
        }
        TreeMap<Integer, Integer> headersMap = new TreeMap<Integer, Integer>();
        int cptCol = 0;
        for (CellsGroup header : this._header) {
            int column = header.getFirstColumn();
            for (StylizedCell cell : header) {
                returnTable[0][cptCol] = cell;
                headersMap.put(column, cptCol);
                ++column;
                ++cptCol;
            }
        }
        int cptrow = 1;
        for (SubRow row : this._rows) {
            for (CellsGroup rowcg : row) {
                int column = rowcg.getFirstColumn();
                for (StylizedCell cell : rowcg) {
                    returnTable[cptrow][((Integer)headersMap.get((Object)Integer.valueOf((int)column))).intValue()] = cell;
                    ++column;
                }
            }
            ++cptrow;
        }
        return returnTable;
    }

    @Override
    public String getText() {
        Cell[][] returnTable = this.finalizeTable();
        String str = "-----------------------------------------------------------------------------\n";
        str = String.valueOf(str) + "Titre: " + this._title + "\n";
        int i = 0;
        while (i < this._rows.size() + 1) {
            int j = 0;
            while (j < this._header.getNbColumn()) {
                if (returnTable[i][j] instanceof StylizedCell) {
                    StylizedCell cell = (StylizedCell)returnTable[i][j];
                    str = String.valueOf(str) + cell.getText();
                    str = String.valueOf(str) + "|";
                } else {
                    str = String.valueOf(str) + "NA";
                    str = String.valueOf(str) + "|";
                }
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }

    public String toString() {
        String str = "-----------------------------------------------------------------------------\n";
        str = String.valueOf(str) + this._header.toString();
        str = String.valueOf(str) + '\n';
        str = String.valueOf(str) + "Size: " + this._rows.size();
        return str;
    }
}

