/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Chunk;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Doc2ModelTextStripper;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.DocumentElement;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.PageElement;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Paragraph;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.ScoreParagraph;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.SimpleParagraph;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.pdf.Style;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class D2MAdvancedPDF2HTML
extends Doc2ModelTextStripper {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final int MAX_ACROFORM_RECURSIONS = 10;
    private boolean inParagraph = false;
    List<DocumentElement> _documentElements = new LinkedList<DocumentElement>();
    Paragraph _lastParagraph = null;
    String _lastChunk = "";
    Style _lastStyle = new Style(Color.black, 11.0f, false);
    Map<String, Float> headerPatternMap = new HashMap<String, Float>();
    private final ContentHandler originalHandler;
    private final ParseContext context;
    private final XHTMLContentHandler handler;
    private final PDFParserConfig config;

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        try {
            D2MAdvancedPDF2HTML pdf2XHTML = new D2MAdvancedPDF2HTML(handler, context, metadata, config);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
    }

    public D2MAdvancedPDF2HTML(ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        this.config = config;
        this.originalHandler = handler;
        this.context = context;
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.setForceParsing(true);
        this.setSortByPosition(config.getSortByPosition());
        if (config.getEnableAutoSpace()) {
            this.setWordSeparator(" ");
        } else {
            this.setWordSeparator("");
        }
        this.setSuppressDuplicateOverlappingText(config.getSuppressDuplicateOverlappingText());
    }

    void extractBookmarkText() throws SAXException {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline != null) {
            this.extractBookmarkText((PDOutlineNode)outline);
        }
    }

    void extractBookmarkText(PDOutlineNode bookmark) throws SAXException {
        PDOutlineItem current = bookmark.getFirstChild();
        if (current != null) {
            this.handler.startElement("ul");
            while (current != null) {
                this.handler.startElement("li");
                this.handler.characters(current.getTitle());
                this.handler.endElement("li");
                this.extractBookmarkText((PDOutlineNode)current);
                current = current.getNextSibling();
            }
            this.handler.endElement("ul");
        }
    }

    @Override
    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    @Override
    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.renderDocument();
            this.extractBookmarkText();
            this.extractEmbeddedDocuments(pdf, this.originalHandler);
            if (this.config.getExtractAcroFormContent()) {
                this.extractAcroForm(pdf, this.handler);
            }
            this.handler.endDocument();
        }
        catch (TikaException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    @Override
    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
        this.writeParagraphStart();
    }

    @Override
    protected void endPage(PDPage page) throws IOException {
        this.writeParagraphEnd();
        this._documentElements.add(new PageElement(page));
    }

    @Override
    protected void writeParagraphStart() throws IOException {
        if (this.inParagraph) {
            this.writeParagraphEnd();
        }
        assert (!this.inParagraph);
        this.inParagraph = true;
        this._lastParagraph = new SimpleParagraph();
    }

    @Override
    protected void writeParagraphEnd() throws IOException {
        if (!this.inParagraph) {
            this.writeParagraphStart();
        } else {
            ScoreParagraph scorePara = new ScoreParagraph(this._lastParagraph);
            this._documentElements.add(scorePara);
            String str = scorePara.getText().replaceAll("\\s", "");
            Pattern matchedPattern = D2MAdvancedPDF2HTML.matchPattern(str, this.getHeaderOrListItemPatterns());
            if (matchedPattern != null) {
                Float score = this.headerPatternMap.get(matchedPattern.toString());
                if (score != null) {
                    if (score.floatValue() < scorePara.getScoreSize()) {
                        this.headerPatternMap.put(matchedPattern.toString(), Float.valueOf(scorePara.getScoreSize()));
                    }
                } else {
                    this.headerPatternMap.put(matchedPattern.toString(), Float.valueOf(scorePara.getScoreSize()));
                }
            }
        }
        assert (this.inParagraph);
        this.inParagraph = false;
    }

    @Override
    protected void writeString(String text) throws IOException {
        this._lastChunk = String.valueOf(this._lastChunk) + text;
    }

    @Override
    protected void writeCharacters(TextPosition text) throws IOException {
        this._lastChunk = String.valueOf(this._lastChunk) + text.getCharacter();
    }

    @Override
    protected void writeWordSeparator() throws IOException {
        this._lastChunk = String.valueOf(this._lastChunk) + this.getWordSeparator();
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        SimpleParagraph para = new SimpleParagraph();
        para.setType(Paragraph.ParagraphType.NL);
        this._documentElements.add(new ScoreParagraph(para));
    }

    @Override
    protected void writeStyleStart(Color fontColor, float fontSize, boolean bold) throws IOException {
        this._lastStyle = new Style(fontColor, fontSize, bold);
    }

    @Override
    protected void writeStyleEnd() throws IOException {
        this._lastParagraph.addChunk(this._lastStyle, this._lastChunk);
        this._lastChunk = "";
    }

    void renderParagraph(Paragraph paragraph) throws SAXException {
        String span = "";
        for (Chunk chunk : paragraph.getChunks()) {
            if (chunk.getText().replaceAll("\\s", "").length() > 0) {
                Color color = chunk.getStyle().get_color();
                span = "color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                span = String.valueOf(span) + ";font-size:" + chunk.getStyle().get_fontSize() + "pt";
                if (chunk.getStyle().is_bold()) {
                    this.handler.startElement("b");
                    this.handler.startElement("span", "style", span);
                    this.handler.characters(chunk.getText());
                    this.handler.endElement("span");
                    this.handler.endElement("b");
                    continue;
                }
                this.handler.startElement("span", "style", span);
                this.handler.characters(chunk.getText());
                this.handler.endElement("span");
                continue;
            }
            this.handler.characters(chunk.getText());
        }
    }

    protected void renderDocument() throws IOException {
        try {
            HashMap<String, Integer> patternMap = new HashMap<String, Integer>();
            int hiearchy = 0;
            int currentHeaderHiearchy = 0;
            for (DocumentElement elt : this._documentElements) {
                if (elt instanceof ScoreParagraph) {
                    ScoreParagraph para = (ScoreParagraph)elt;
                    String str = para.getText().replaceAll("\\s", "");
                    Pattern matchedPattern = D2MAdvancedPDF2HTML.matchPattern(str, this.getHeaderOrListItemPatterns());
                    if (matchedPattern != null && para.getScoreSize() >= this.headerPatternMap.get(matchedPattern.toString()).floatValue()) {
                        Integer ret = (Integer)patternMap.get(matchedPattern.toString());
                        if (ret == null) {
                            patternMap.put(matchedPattern.toString(), ++hiearchy);
                            currentHeaderHiearchy = hiearchy > 6 ? 6 : hiearchy;
                            this.handler.startElement("h" + currentHeaderHiearchy);
                            this.renderParagraph(para);
                            this.handler.endElement("h" + currentHeaderHiearchy);
                            continue;
                        }
                        currentHeaderHiearchy = ret;
                        currentHeaderHiearchy = currentHeaderHiearchy > 6 ? 6 : currentHeaderHiearchy;
                        this.handler.startElement("h" + currentHeaderHiearchy);
                        this.renderParagraph(para);
                        this.handler.endElement("h" + currentHeaderHiearchy);
                        continue;
                    }
                    this.handler.startElement("p");
                    this.renderParagraph(para);
                    this.handler.endElement("p");
                    continue;
                }
                if (!(elt instanceof PageElement)) continue;
                PDPage page = ((PageElement)elt).getPage();
                if (this.config.getExtractAnnotationText()) {
                    for (Object o : page.getAnnotations()) {
                        PDActionURI uri;
                        String link;
                        PDAction action;
                        PDAnnotationLink annotationlink;
                        if (o instanceof PDAnnotationLink && (annotationlink = (PDAnnotationLink)o).getAction() != null && (action = annotationlink.getAction()) instanceof PDActionURI && (link = (uri = (PDActionURI)action).getURI()) != null) {
                            this.handler.startElement("div", "class", "annotation");
                            this.handler.startElement("a", "href", link);
                            this.handler.endElement("a");
                            this.handler.endElement("div");
                        }
                        if (!(o instanceof PDAnnotationMarkup)) continue;
                        PDAnnotationMarkup annot = (PDAnnotationMarkup)o;
                        String title = annot.getTitlePopup();
                        String subject = annot.getSubject();
                        String contents = annot.getContents();
                        if (title == null && subject == null && contents == null) continue;
                        this.handler.startElement("div", "class", "annotation");
                        if (title != null) {
                            this.handler.startElement("div", "class", "annotationTitle");
                            this.handler.characters(title);
                            this.handler.endElement("div");
                        }
                        if (subject != null) {
                            this.handler.startElement("div", "class", "annotationSubject");
                            this.handler.characters(subject);
                            this.handler.endElement("div");
                        }
                        if (contents != null) {
                            this.handler.startElement("div", "class", "annotationContents");
                            this.handler.characters(contents);
                            this.handler.endElement("div");
                        }
                        this.handler.endElement("div");
                    }
                }
                this.handler.endElement("div");
            }
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    private void extractEmbeddedDocuments(PDDocument document, ContentHandler handler) throws IOException, SAXException, TikaException {
        Map embeddedFileNames;
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names == null) {
            return;
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return;
        }
        EmbeddedDocumentExtractor embeddedExtractor = (EmbeddedDocumentExtractor)this.context.get(EmbeddedDocumentExtractor.class);
        if (embeddedExtractor == null) {
            embeddedExtractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        if ((embeddedFileNames = embeddedFiles.getNames()) != null) {
            this.processEmbeddedDocNames(embeddedFileNames, embeddedExtractor);
        } else {
            List kids = embeddedFiles.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode n : kids) {
                Map childNames = n.getNames();
                if (childNames == null) continue;
                this.processEmbeddedDocNames(childNames, embeddedExtractor);
            }
        }
    }

    private void processEmbeddedDocNames(Map<String, COSObjectable> embeddedFileNames, EmbeddedDocumentExtractor embeddedExtractor) throws IOException, SAXException, TikaException {
        if (embeddedFileNames == null) {
            return;
        }
        for (Map.Entry<String, COSObjectable> ent : embeddedFileNames.entrySet()) {
            PDComplexFileSpecification spec = (PDComplexFileSpecification)ent.getValue();
            PDEmbeddedFile file = spec.getEmbeddedFile();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", ent.getKey());
            metadata.set("Content-Type", file.getSubtype());
            metadata.set("Content-Length", Long.toString(file.getSize()));
            if (!embeddedExtractor.shouldParseEmbedded(metadata)) continue;
            TikaInputStream stream = TikaInputStream.get((InputStream)file.createInputStream());
            try {
                embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.handler), metadata, false);
            }
            finally {
                stream.close();
            }
        }
    }

    private void extractAcroForm(PDDocument pdf, XHTMLContentHandler handler) throws IOException, SAXException {
        PDDocumentCatalog catalog = pdf.getDocumentCatalog();
        if (catalog == null) {
            return;
        }
        PDAcroForm form = catalog.getAcroForm();
        if (form == null) {
            return;
        }
        List fields = form.getFields();
        if (fields == null) {
            return;
        }
        ListIterator itr = fields.listIterator();
        if (itr == null) {
            return;
        }
        handler.startElement("div", "class", "acroform");
        handler.startElement("ol");
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj == null || !(obj instanceof PDField)) continue;
            this.processAcroField((PDField)obj, handler, 0);
        }
        handler.endElement("ol");
        handler.endElement("div");
    }

    private void processAcroField(PDField field, XHTMLContentHandler handler, int recurseDepth) throws SAXException, IOException {
        if (recurseDepth >= 10) {
            return;
        }
        this.addFieldString(field, handler);
        List kids = field.getKids();
        if (kids != null) {
            Iterator kidsIter = kids.iterator();
            if (kidsIter == null) {
                return;
            }
            int r = recurseDepth + 1;
            handler.startElement("ol");
            while (kidsIter.hasNext()) {
                Object pdfObj = kidsIter.next();
                if (pdfObj == null || !(pdfObj instanceof PDField)) continue;
                PDField kid = (PDField)pdfObj;
                this.processAcroField(kid, handler, r);
            }
            handler.endElement("ol");
        }
    }

    private void addFieldString(PDField field, XHTMLContentHandler handler) throws SAXException {
        String partName = field.getPartialName();
        String altName = field.getAlternateFieldName();
        StringBuilder sb = new StringBuilder();
        AttributesImpl attrs = new AttributesImpl();
        if (partName != null) {
            sb.append(partName).append(": ");
        }
        if (altName != null) {
            attrs.addAttribute("", "altName", "altName", "CDATA", altName);
        }
        if (field instanceof PDSignatureField) {
            this.handleSignature(attrs, (PDSignatureField)field, handler);
            return;
        }
        try {
            String value = field.getValue();
            if (value != null && !value.equals("null")) {
                sb.append(value);
            }
        }
        catch (IOException iOException) {}
        if (attrs.getLength() > 0 || sb.length() > 0) {
            handler.startElement("li", attrs);
            handler.characters(sb.toString());
            handler.endElement("li");
        }
    }

    private void handleSignature(AttributesImpl parentAttributes, PDSignatureField sigField, XHTMLContentHandler handler) throws SAXException {
        PDSignature sig = sigField.getSignature();
        if (sig == null) {
            return;
        }
        TreeMap<String, String> vals = new TreeMap<String, String>();
        vals.put("name", sig.getName());
        vals.put("contactInfo", sig.getContactInfo());
        vals.put("location", sig.getLocation());
        vals.put("reason", sig.getReason());
        Calendar cal = sig.getSignDate();
        if (cal != null) {
            this.dateFormat.setTimeZone(cal.getTimeZone());
            vals.put("date", this.dateFormat.format(cal.getTime()));
        }
        int nonNull = 0;
        for (String val : vals.keySet()) {
            if (val == null || val.equals("")) continue;
            ++nonNull;
        }
        if (nonNull > 0) {
            handler.startElement("li", parentAttributes);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "signaturedata");
            handler.startElement("ol", attrs);
            for (Map.Entry e : vals.entrySet()) {
                if (e.getValue() == null || ((String)e.getValue()).equals("")) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("", "signdata", "signdata", "CDATA", (String)e.getKey());
                handler.startElement("li", attrs);
                handler.characters((String)e.getValue());
                handler.endElement("li");
            }
            handler.endElement("ol");
            handler.endElement("li");
        }
    }
}

