/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.xls.wizard;

import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.polarsys.reqcycle.export.AbstractExportWizard;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Export;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Model;
import org.polarsys.reqcycle.export.pages.RequirementSourceSelectionPage;
import org.polarsys.reqcycle.export.pages.WizardController;
import org.polarsys.reqcycle.export.xls.acceleo.Generate;
import org.polarsys.reqcycle.export.xls.acceleo.GenerateCSV;
import org.polarsys.reqcycle.export.xls.wizard.ExcelController;
import org.polarsys.reqcycle.export.xls.wizard.pages.ExcelOutputPage;
import org.polarsys.reqcycle.export.xls.wizard.pages.SourceAndExtensionSelectionPage;

public class TraceabilityExportWizard
extends AbstractExportWizard {
    private static final CharMatcher ALNUM = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.WHITESPACE).precomputed();
    private ExcelOutputPage excelOutputPage;

    protected IWizardPage getOutputPage(WizardController controller) {
        this.excelOutputPage = new ExcelOutputPage(controller);
        return this.excelOutputPage;
    }

    protected boolean isExportTraceability() {
        return this.controller.getProjectsResult().size() != 0;
    }

    protected WizardController getController() {
        return new ExcelController();
    }

    protected RequirementSourceSelectionPage getSourceSelectionPage() {
        return new SourceAndExtensionSelectionPage(this.controller);
    }

    protected void doTransform(Export export, IProgressMonitor monitor) throws Exception {
        try {
            String path = export.getPath();
            File f = new File(path);
            if (f.exists()) {
                try {
                    FileChannel channel = new RandomAccessFile(f, "rw").getChannel();
                    channel.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new Exception("the file can't be written, verify if the file is not opened");
                }
            }
            for (Model m : export.getModels()) {
                m.setName(this.trim(m.getName()));
            }
            String folder = path.substring(0, path.lastIndexOf("/"));
            export.setPath(path.substring(path.lastIndexOf("/") + 1, path.length()));
            AbstractAcceleoGenerator g = this.getGenerator(export, folder);
            g.generate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            IContainer iFolder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(folder));
            if (iFolder != null && iFolder.exists()) {
                iFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (AcceleoEvaluationException e) {
            throw new Exception(e);
        }
    }

    protected AbstractAcceleoGenerator getGenerator(Export export, String folder) throws IOException {
        if (export.getPath().endsWith("xls")) {
            return new Generate((EObject)export, new File(folder), new LinkedList());
        }
        if (export.getPath().endsWith("csv")) {
            return new GenerateCSV((EObject)export, new File(folder), new LinkedList());
        }
        return null;
    }

    private String trim(String name) {
        return ALNUM.negate().removeFrom((CharSequence)name);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        for (Object o : selection) {
            if (!(o instanceof IContainer)) continue;
            IContainer container = (IContainer)o;
            try {
                this.controller.setOutputPath(String.valueOf(container.getLocationURI().toURL().getFile()) + "/output.xls");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

