/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.traceability.sysml.types;

import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.reqcycle.emf.types.EMFTypeChecker;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class SysMLTypeChecker
implements IInjectedTypeChecker {
    @Inject
    IReachableManager manager;
    @IInjectedTypeChecker.InjectValue
    String sysmlElementName;
    @IInjectedTypeChecker.InjectValue
    String umlElementName;
    @IInjectedTypeChecker.InjectValue
    String applicatedStereotype;

    public boolean apply(Reachable reachable) {
        EMFTypeChecker emfTypeChecker = new EMFTypeChecker();
        if (emfTypeChecker.apply(reachable)) {
            try {
                ReachableObject object = this.manager.getHandlerFromReachable(reachable).getFromReachable(reachable);
                IsSysMLVisitor visitor = new IsSysMLVisitor();
                object.getVisitable().accept((IVisitor)visitor);
                return visitor.found;
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isElementOK(Element e) {
        boolean isOK = true;
        if (this.umlElementName != null) {
            isOK = this.umlElementName.equalsIgnoreCase(e.eClass().getName());
        }
        return isOK;
    }

    public boolean isStereotypeOk(Element e) {
        boolean isOK = true;
        if (this.applicatedStereotype != null) {
            isOK = false;
            for (Stereotype s : e.getAppliedStereotypes()) {
                if (!this.applicatedStereotype.equalsIgnoreCase(s.getName())) continue;
                isOK = true;
                break;
            }
        }
        return isOK;
    }

    public boolean isSysMLOK(EObject e) {
        boolean found = true;
        if (this.sysmlElementName != null) {
            found = e.eClass().getName().equalsIgnoreCase(this.sysmlElementName);
        }
        return found;
    }

    class IsSysMLVisitor
    implements IVisitor {
        boolean found = false;

        IsSysMLVisitor() {
        }

        public void start(IAdaptable adaptable) {
        }

        public boolean visit(Object o, IAdaptable adaptable) {
            if (o instanceof Element) {
                Element e = (Element)o;
                EList eobjects = e.getStereotypeApplications();
                for (EObject tmp : eobjects) {
                    if (tmp.eIsProxy() || !tmp.eClass().getEPackage().getNsURI().contains("http://www.eclipse.org/papyrus/0.7.0/SysML")) continue;
                    if (SysMLTypeChecker.this.sysmlElementName == null && SysMLTypeChecker.this.applicatedStereotype == null && SysMLTypeChecker.this.umlElementName == null) {
                        this.found = true;
                        break;
                    }
                    if (!SysMLTypeChecker.this.isElementOK(e) || !SysMLTypeChecker.this.isStereotypeOk(e) || !SysMLTypeChecker.this.isSysMLOK(tmp)) continue;
                    this.found = true;
                    break;
                }
            }
            return false;
        }

        public void end(IAdaptable adaptable) {
        }

        boolean getResult() {
            return this.found;
        }
    }
}

