/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.PrimitiveTypeRefCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.completeoclcs.ContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.DefOperationCS;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.utils.ocl.OCLEvaluator;

public class OCLUtilities {
    protected static Map<String, String> mapToOCLPrimitives = new HashMap<String, String>();

    static {
        mapToOCLPrimitives.put("String", "String");
        mapToOCLPrimitives.put("Boolean", "Boolean");
        mapToOCLPrimitives.put("boolean", "Boolean");
        mapToOCLPrimitives.put("Float", "Real");
        mapToOCLPrimitives.put("int", "Integer");
        mapToOCLPrimitives.put("Int", "Integer");
        mapToOCLPrimitives.put("long", "Integer");
        mapToOCLPrimitives.put("Long", "Integer");
        mapToOCLPrimitives.put("Short", "Integer");
    }

    public static BaseCSResource loadOCLResource(ResourceSet resourceSet, URI oclURI) throws WrappedException {
        BaseCSResource xtextResource = null;
        CompleteOCLStandaloneSetup.init();
        try {
            xtextResource = (BaseCSResource)resourceSet.getResource(oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (BaseCSResource)resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return xtextResource;
    }

    public static Collection<DefOperationCS> getOperations(BaseCSResource resource) {
        EObject root;
        ArrayList result = Lists.newArrayList();
        EList contents = resource.getContents();
        if (contents.size() == 1 && (root = (EObject)contents.get(0)) instanceof CompleteOCLDocumentCS) {
            EList contexts = ((CompleteOCLDocumentCS)root).getOwnedContexts();
            for (ContextDeclCS context : contexts) {
                if (!(context instanceof ClassifierContextDeclCS)) continue;
                EList definitions = ((ClassifierContextDeclCS)context).getOwnedDefinitions();
                Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)definitions, DefOperationCS.class));
            }
        }
        return result;
    }

    public static IStatus isOperationPresent(IRequirementType type, BaseCSResource resource) {
        if (Iterables.size(OCLUtilities.getMatchingOperations(type, resource)) > 0) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.polarsys.reqcycle.ocl", "Required operation : " + OCLUtilities.getOperationRequiredSignature(type) + " could not be found");
    }

    public static IStatus isOperationPresent(IAttribute attribute, BaseCSResource resource) {
        String attributeTypeName = attribute.getType().getName();
        if (!mapToOCLPrimitives.containsKey(attributeTypeName)) {
            return new Status(2, "org.polarsys.reqcycle.ocl", "Type " + attributeTypeName + " cannot be used in OCL.");
        }
        if (Iterables.size(OCLUtilities.getMatchingOperations(attribute, resource)) > 0) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.polarsys.reqcycle.ocl", "Required operation : " + OCLUtilities.getOperationRequiredSignature(attribute) + " could not be found.");
    }

    public static Iterable<DefOperationCS> getMatchingOperations(final IRequirementType type, BaseCSResource resource) {
        Collection<DefOperationCS> operations = OCLUtilities.getOperations(resource);
        if (operations == null || Iterables.isEmpty(operations)) {
            return Collections.emptyList();
        }
        return Iterables.filter(operations, (Predicate)new Predicate<DefOperationCS>(){

            public boolean apply(DefOperationCS arg0) {
                String returnType;
                TypedRefCS operationReturnType = arg0.getOwnedType();
                if (!arg0.getOwnedParameters().isEmpty()) {
                    return false;
                }
                if (operationReturnType instanceof PrimitiveTypeRefCS && !"Boolean".equals(returnType = ((PrimitiveTypeRefCS)operationReturnType).getName())) {
                    return false;
                }
                return arg0.getName().replaceAll("\\s", "").equalsIgnoreCase(OCLUtilities.getOperationRequiredName(type));
            }
        });
    }

    public static Iterable<DefOperationCS> getMatchingOperations(final IAttribute attribute, BaseCSResource resource) {
        Collection<DefOperationCS> operations = OCLUtilities.getOperations(resource);
        if (operations == null || Iterables.isEmpty(operations)) {
            return Collections.emptyList();
        }
        return Iterables.filter(operations, (Predicate)new Predicate<DefOperationCS>(){

            public boolean apply(DefOperationCS arg0) {
                TypedRefCS operationReturnType = arg0.getOwnedType();
                if (!arg0.getOwnedParameters().isEmpty()) {
                    return false;
                }
                if (operationReturnType instanceof PrimitiveTypeRefCS) {
                    String returnType = ((PrimitiveTypeRefCS)operationReturnType).getName();
                    String attributeTypeName = attribute.getType().getName();
                    String lookupResult = mapToOCLPrimitives.get(attributeTypeName);
                    if (lookupResult == null || !lookupResult.equals(returnType)) {
                        return false;
                    }
                }
                return arg0.getName().equalsIgnoreCase(OCLUtilities.getOperationRequiredName(attribute));
            }
        });
    }

    public static String getOperationRequiredName(IRequirementType type) {
        String dataTypeName = type.getName();
        return OCLUtilities.getOperationRequiredName(dataTypeName);
    }

    public static String getOperationRequiredName(String dataTypeName) {
        StringBuilder builder = new StringBuilder("is");
        builder.append(Character.toUpperCase(dataTypeName.charAt(0))).append(dataTypeName.substring(1));
        return builder.toString().replaceAll("\\s", "");
    }

    public static String getOperationRequiredName(IAttribute attribute) {
        StringBuilder builder = new StringBuilder("get");
        String name = attribute.getName();
        builder.append(Character.toUpperCase(name.charAt(0))).append(name.substring(1));
        return builder.toString().replaceAll("\\s", "");
    }

    public static String getOperationRequiredSignature(IRequirementType type) {
        return String.valueOf(OCLUtilities.getOperationRequiredName(type)) + "() : Boolean";
    }

    public static String getOperationRequiredSignature(IAttribute attribute) {
        String returnTypeName = attribute.getType().getName();
        String lookupType = mapToOCLPrimitives.get(returnTypeName);
        return String.valueOf(OCLUtilities.getOperationRequiredName(attribute)) + "() : " + lookupType;
    }

    public static boolean isDataType(OCLEvaluator evaluator, EObject eObject, IRequirementType type) {
        Object result;
        String operationName = OCLUtilities.getOperationRequiredName(type);
        EOperation eOperation = evaluator.getCompiledOperation(operationName, (Object)eObject);
        if (eOperation != null && (result = evaluator.evaluateOperation(eOperation, eObject, new Object[0])) instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public static boolean isSection(OCLEvaluator evaluator, EObject eObject) {
        Object result;
        EOperation eOperation = OCLUtilities.getSectionMethod(evaluator, eObject);
        if (eOperation != null && (result = evaluator.evaluateOperation(eOperation, eObject, new Object[0])) instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    private static EOperation getSectionMethod(OCLEvaluator evaluator, EObject eObject) {
        String operationName = OCLUtilities.getOperationRequiredName("Section");
        EOperation eOperation = evaluator.getCompiledOperation(operationName, (Object)eObject);
        return eOperation;
    }

    public static Object getAttributeValue(OCLEvaluator evaluator, EObject eObject, IAttribute attribute) {
        String operationName = OCLUtilities.getOperationRequiredName(attribute);
        EClassifier type = OCLUtilities.getDataType(attribute);
        return OCLUtilities.getAttributeValue(evaluator, eObject, operationName, type);
    }

    public static Object getAttributeValue(OCLEvaluator evaluator, EObject eObject, String operationName, EClassifier type) {
        EOperation eOperation = evaluator.getCompiledOperation(operationName, (Object)eObject);
        if (eOperation != null) {
            Object result = evaluator.evaluateOperation(eOperation, eObject, new Object[0]);
            if (type == null) {
                return null;
            }
            if (type.isInstance(result)) {
                return result;
            }
            Object converted = OCLUtilities.convertResult(result, type);
            if (type.isInstance(converted)) {
                return converted;
            }
        }
        return null;
    }

    private static EClassifier getDataType(IAttribute attribute) {
        EClassifier type = null;
        if (attribute.getType() instanceof IAdaptable) {
            type = (EClassifier)((IAdaptable)attribute.getType()).getAdapter(EClassifier.class);
        }
        return type;
    }

    protected static Object convertResult(Object result, EClassifier type) {
        if (type == null) {
            return null;
        }
        String instanceClass = type.getInstanceClassName();
        if ("float".equalsIgnoreCase(instanceClass) && result instanceof Double) {
            return Float.valueOf(((Double)result).floatValue());
        }
        return null;
    }
}

