/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.model.scopes;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.ResourceScope;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.utils.ReachableUtils;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class Scopes {
    static IReachableListenerManager lManager = (IReachableListenerManager)ZigguratInject.make(IReachableListenerManager.class);
    static IReachableManager rManager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
    static Set<Reachable> WORKSPACE_REACHABLES = null;
    static Executor exec = Executors.newSingleThreadExecutor();

    static {
        ResourceVisitor visitor = Scopes.getVisitor();
        WORKSPACE_REACHABLES = Sets.newHashSet(visitor.getResult().getReachables());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta.getResource() instanceof IFile) {
                                if (delta.getKind() == 1) {
                                    WORKSPACE_REACHABLES.add(ReachableUtils.getReachable((IResource)delta.getResource()));
                                } else if (delta.getKind() == 2) {
                                    WORKSPACE_REACHABLES.remove(ReachableUtils.getReachable((IResource)delta.getResource()));
                                }
                                try {
                                    final Reachable r = rManager.getHandlerFromObject((Object)delta.getResource()).getFromObject((Object)delta.getResource()).getReachable();
                                    if (r != null) {
                                        exec.execute(new Runnable(){

                                            @Override
                                            public void run() {
                                                lManager.notifyChanged(new Reachable[]{r});
                                            }
                                        });
                                    }
                                }
                                catch (IReachableHandlerException iReachableHandlerException) {}
                            }
                            return true;
                        }
                    }, 1);
                }
                catch (CoreException coreException) {
                    ResourceVisitor visitor = Scopes.getVisitor();
                    WORKSPACE_REACHABLES = Sets.newHashSet(visitor.getResult().getReachables());
                }
            }
        });
    }

    private static ResourceVisitor getVisitor() {
        ResourceVisitor visitor = new ResourceVisitor();
        ZigguratInject.inject((Object[])new Object[]{visitor});
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return visitor;
    }

    public static IScope getProjectScope(IResource r) {
        ResourceVisitor visitor = new ResourceVisitor();
        ZigguratInject.inject((Object[])new Object[]{visitor});
        try {
            r.getProject().accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static IScope getSubTree(IResource r) {
        ResourceVisitor visitor = new ResourceVisitor();
        ZigguratInject.inject((Object[])new Object[]{visitor});
        try {
            r.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static IScope getWorkspaceScope() {
        return new ResourceScope(WORKSPACE_REACHABLES);
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        CompositeScope scope = new CompositeScope();

        private ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            Reachable r = ReachableUtils.getReachable((IResource)resource);
            if (r != null) {
                this.scope.add(new ResourceScope(r));
            }
            return true;
        }

        public IScope getResult() {
            return this.scope;
        }
    }
}

