/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder;

import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.reqcycle.uri.visitors.IVisitor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class LabelledVisitor
implements IVisitor {
    private String label;
    private String description;
    private IVisitor delegate;
    private static String EXT_POINT = "traceabilityAnalyser";
    private static String LABEL = "label";
    private static String DESCRIPTION = "description";
    private static Collection<LabelledVisitor> visitors = null;

    public static Collection<LabelledVisitor> getRegisteredVisitors() {
        if (visitors == null) {
            visitors = new ArrayDeque<LabelledVisitor>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.traceability.builder", EXT_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    String description;
                    IVisitor v = (IVisitor)e.createExecutableExtension("visitor");
                    ZigguratInject.inject((Object[])new Object[]{v});
                    String label = e.getAttribute(LABEL);
                    if (label == null || label.length() == 0) {
                        label = v.getClass().getName();
                    }
                    if ((description = e.getAttribute(DESCRIPTION)) == null) {
                        description = " analyser registered in bundle : " + FrameworkUtil.getBundle(v.getClass()).getSymbolicName();
                    }
                    LabelledVisitor labelled = new LabelledVisitor(label, description, v);
                    visitors.add(labelled);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                ++n2;
            }
        }
        return visitors;
    }

    public LabelledVisitor(String label, String description, IVisitor delegate) {
        this.label = label;
        this.description = description;
        this.delegate = delegate;
    }

    public void start(IAdaptable adaptable) {
        this.delegate.start(adaptable);
    }

    public boolean visit(Object o, IAdaptable adaptable) {
        return this.delegate.visit(o, adaptable);
    }

    public void end(IAdaptable adaptable) {
        this.delegate.end(adaptable);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends IVisitor> getVisitorClass() {
        return this.delegate.getClass();
    }
}

