/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.listeners;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.predicates.core.PredicatesFactory;
import org.polarsys.reqcycle.predicates.core.api.BooleanEqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.CompareNumberPredicate;
import org.polarsys.reqcycle.predicates.core.api.CompositePredicate;
import org.polarsys.reqcycle.predicates.core.api.ContainsPatternPredicate;
import org.polarsys.reqcycle.predicates.core.api.DateEqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.EnumEqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.EnumIntoPredicate;
import org.polarsys.reqcycle.predicates.core.api.EqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.IEAttrPredicate;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.api.ITypedPredicate;
import org.polarsys.reqcycle.predicates.core.api.IntoPredicate;
import org.polarsys.reqcycle.predicates.core.api.IsTypeOfPredicate;
import org.polarsys.reqcycle.predicates.core.api.OperationPredicate;
import org.polarsys.reqcycle.predicates.core.api.StringEqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.StringIntoPredicate;
import org.polarsys.reqcycle.predicates.core.api.StringParameter;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.predicates.ui.components.SelectTypeDialog;
import org.polarsys.reqcycle.predicates.ui.dialogs.IEAttrPredicatesNodeEditorDialog;
import org.polarsys.reqcycle.predicates.ui.dialogs.OperationDialog;
import org.polarsys.reqcycle.predicates.ui.dialogs.PredicateValueEditor;
import org.polarsys.reqcycle.predicates.ui.presentation.PredicatesEditor;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class PredicatesTreeDoubleClickListener
implements IDoubleClickListener {
    private final PredicatesEditor editor;
    private Collection<EClass> eClasses;
    private boolean useExtendedFeature;
    IPredicatesConfManager manager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);

    public PredicatesTreeDoubleClickListener(PredicatesEditor editor, Collection<EClass> eClassesOfModelToEdit, boolean useExtendedFeature) {
        this.editor = editor;
        this.eClasses = eClassesOfModelToEdit;
        this.useExtendedFeature = useExtendedFeature;
    }

    public void doubleClick(DoubleClickEvent event) {
        Shell parent = event.getViewer().getControl().getShell();
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof CompositePredicate) {
            MessageDialog.openInformation((Shell)parent, (String)"Info", (String)"Unable to edit a Composite Predicate.");
            return;
        }
        if (selection.getFirstElement() instanceof OperationPredicate) {
            OperationPredicate predicate = (OperationPredicate)selection.getFirstElement();
            OperationDialog dialog = new OperationDialog(predicate, Display.getDefault().getActiveShell());
            int result = dialog.open();
            if (result == 0) {
                predicate.setOperationName(dialog.getOperationName());
                predicate.getParameters().clear();
                for (Map.Entry<String, GenericEAttrPropsEditor> entry : dialog.getEditors().entrySet()) {
                    StringParameter param;
                    GenericEAttrPropsEditor editor = entry.getValue();
                    Object obj = editor.getEnteredValue();
                    if (obj instanceof String) {
                        param = PredicatesFactory.eINSTANCE.createStringParameter();
                        param.setName(entry.getKey());
                        param.setValue((String)obj);
                        predicate.getParameters().add((Object)param);
                        continue;
                    }
                    if (obj instanceof Integer) {
                        param = PredicatesFactory.eINSTANCE.createIntParameter();
                        param.setName(entry.getKey());
                        param.setValue(((Integer)obj).intValue());
                        predicate.getParameters().add((Object)param);
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        param = PredicatesFactory.eINSTANCE.createBooleanParameter();
                        param.setName(entry.getKey());
                        param.setValue(((Boolean)obj).booleanValue());
                        predicate.getParameters().add((Object)param);
                        continue;
                    }
                    if (!(obj instanceof EObject)) continue;
                    param = PredicatesFactory.eINSTANCE.createEObjectParameter();
                    param.setName(entry.getKey());
                    param.setValue((EObject)obj);
                    predicate.getParameters().add((Object)param);
                }
            }
            return;
        }
        if (selection.getFirstElement() instanceof EqualPredicate) {
            EqualPredicate predicate = (EqualPredicate)selection.getFirstElement();
            PredicateValueEditor dialog = null;
            if (selection.getFirstElement() instanceof StringEqualPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)predicate, String.class, false);
            } else if (selection.getFirstElement() instanceof BooleanEqualPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)predicate, Boolean.class, false);
            } else if (selection.getFirstElement() instanceof EnumEqualPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)predicate, Enum.class, false);
            } else if (selection.getFirstElement() instanceof DateEqualPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)predicate, Date.class, false);
            }
            if (dialog != null && dialog.open() == 0) {
                predicate.setExpectedObject(dialog.getEditor().getEnteredValue());
            }
            return;
        }
        if (selection.getFirstElement() instanceof IntoPredicate) {
            PredicateValueEditor dialog = null;
            if (selection.getFirstElement() instanceof StringIntoPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)selection.getFirstElement(), String.class, false);
            } else if (selection.getFirstElement() instanceof EnumIntoPredicate) {
                dialog = new PredicateValueEditor(parent, (IPredicate)selection.getFirstElement(), Enum.class, false);
            }
            if (dialog != null && dialog.open() == 0) {
                IntoPredicate predicate = (IntoPredicate)selection.getFirstElement();
                predicate.getAllowedEntries().add(dialog.getEditor().getEnteredValue());
            }
            return;
        }
        if (selection.getFirstElement() instanceof ContainsPatternPredicate) {
            PredicateValueEditor dialog = new PredicateValueEditor(parent, (IPredicate)selection.getFirstElement(), String.class, false);
            if (dialog.open() == 0) {
                String value = (String)dialog.getEditor().getEnteredValue();
                ContainsPatternPredicate predicate = (ContainsPatternPredicate)selection.getFirstElement();
                Pattern pattern = Pattern.compile(value);
                predicate.setExpectedPattern(pattern);
            }
            return;
        }
        if (selection.getFirstElement() instanceof CompareNumberPredicate) {
            PredicateValueEditor dialog = new PredicateValueEditor(parent, (IPredicate)selection.getFirstElement(), Number.class, true);
            if (dialog.open() == 0) {
                CompareNumberPredicate predicate = (CompareNumberPredicate)selection.getFirstElement();
                predicate.setOperator(dialog.getOperator());
                predicate.setExpectedValue((Number)dialog.getEditor().getEnteredValue());
            }
            return;
        }
        if (this.eClasses == null || this.eClasses.isEmpty()) {
            MessageDialog.openError((Shell)parent, (String)"Error", (String)"You must load a model to edit.");
            return;
        }
        if (selection.getFirstElement() instanceof IsTypeOfPredicate) {
            Object type;
            SelectTypeDialog dialog = new SelectTypeDialog(parent, this.eClasses);
            if (dialog.open() == 0 && (type = dialog.getResult()) instanceof EClass) {
                Boolean isStrict = dialog.getIsStrictTypeOf();
                IsTypeOfPredicate predicate = (IsTypeOfPredicate)selection.getFirstElement();
                predicate.setType((EClass)type);
                predicate.setIsStrictTypeOf(isStrict.booleanValue());
            }
            return;
        }
        if (selection.getFirstElement() instanceof ITypedPredicate) {
            System.out.println("double click on ITypedPredicate predicate");
            ITypedPredicate predicate = (ITypedPredicate)selection.getFirstElement();
            if (predicate instanceof IEAttrPredicate) {
                IEAttrPredicatesNodeEditorDialog dialog = new IEAttrPredicatesNodeEditorDialog(parent, (IEAttrPredicate)predicate, this.eClasses, this.useExtendedFeature);
                if (dialog.open() == 0 && selection.getFirstElement() instanceof IEAttrPredicate) {
                    ((IEAttrPredicate)selection.getFirstElement()).setTypedElement((Object)dialog.getSelectedEAttribute());
                }
            } else {
                MessageDialog.openError((Shell)parent, (String)"Error", (String)"Only IEAttrPredicate is currently supported.");
            }
        }
    }

    public void setEClasses(Collection<EClass> eClasses) {
        this.eClasses = eClasses;
    }

    public void setUseExtendedFeature(boolean useExtendedFeature) {
        this.useExtendedFeature = useExtendedFeature;
    }
}

