/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.ModelUtils;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.tesla.internal.core.network.IProgressInformer;

public class TeslaReplayer {
    public int replayCommands(UIPlayer player, TeslaScenarioContainer container, IProgressInformer informer, IProgressMonitor monitor, IReplayPreExecute preExecutor) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean success = true;
        int index = 0;
        Command workCmd = null;
        try {
            if (!container.isEmpty()) {
                HashMap<String, Element> elementToRealElementMap = new HashMap<String, Element>();
                List<Command> commands = container.getCommands();
                for (Command cmd : commands) {
                    Set<Element> realElements;
                    if (preExecutor != null && preExecutor.preExecute(cmd)) continue;
                    workCmd = cmd != null ? (Command)EcoreUtil.copy((EObject)cmd) : null;
                    try {
                        ModelUtils.updateElementsAccordingTo(workCmd, elementToRealElementMap, new HashSet<EObject>());
                    }
                    catch (Exception e) {
                        String msgErr = "Failed to replay at:" + SimpleCommandPrinter.toString(workCmd) + " index:" + index + " msg=Test case is broken...";
                        builder.append(msgErr);
                        if (informer != null) {
                            informer.handleError(container, workCmd, index, msgErr, null);
                        }
                        success = false;
                        int n = index;
                        if (success) {
                            if (informer != null) {
                                builder.append("Replay sucessfully completed...");
                                informer.appendText(builder.toString());
                            }
                            if (monitor != null) {
                                monitor.subTask("Replay sucessfully completed...");
                            }
                        }
                        return n;
                    }
                    String msg = "Replaying command:" + SimpleCommandPrinter.toString(workCmd);
                    builder.append(msg).append('\n');
                    if (monitor != null) {
                        monitor.subTask(msg);
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        int n = index;
                        return n;
                    }
                    List<Element> list = container.getElements(cmd);
                    Response response = null;
                    response = player.safeExecuteCommand(workCmd);
                    if (response == null) {
                        int n = index;
                        return n;
                    }
                    if (!response.getStatus().equals((Object)ResponseStatus.OK)) {
                        String msgErr = "Failed to replay at:" + SimpleCommandPrinter.toString(workCmd) + " index:" + index + " msg=" + response.getMessage();
                        builder.append(msgErr);
                        if (informer != null) {
                            informer.handleError(container, workCmd, index, response.getMessage(), response.getAdvancedInformation());
                        }
                        success = false;
                        int n = index;
                        return n;
                    }
                    if (list != null && list.size() > 0 && (realElements = ModelUtils.extractElements(response)).size() == list.size() && list.size() == 1) {
                        elementToRealElementMap.put(this.makeKey(list.get(0)), realElements.iterator().next());
                    }
                    ++index;
                    if (informer == null) continue;
                    informer.appendText(builder.toString());
                }
            }
            int n = index;
            return n;
        }
        catch (Throwable e) {
            String msgErr = "Failed to replay at:" + SimpleCommandPrinter.toString(workCmd) + " index:" + index + " msg=" + e.getMessage();
            builder.append(msgErr);
            if (informer != null) {
                informer.handleError(container, workCmd, index, e.getMessage(), null);
            }
            success = false;
            int n = index;
            return n;
        }
        finally {
            if (success) {
                if (informer != null) {
                    builder.append("Replay sucessfully completed...");
                    informer.appendText(builder.toString());
                }
                if (monitor != null) {
                    monitor.subTask("Replay sucessfully completed...");
                }
            }
        }
    }

    private String makeKey(Element element) {
        return ModelUtils.makeKey(element);
    }

    public static interface IReplayPreExecute {
        public boolean preExecute(Command var1);
    }
}

