/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    protected Map<String, RGB> keyTable = new HashMap<String, RGB>(10);
    protected Map<Display, Map<RGB, Color>> displayTable = new HashMap<Display, Map<RGB, Color>>(2);
    private final boolean fAutoDisposeOnDisplayDispose;

    public ColorManager() {
        this(true);
    }

    public ColorManager(boolean autoDisposeOnDisplayDispose) {
        this.fAutoDisposeOnDisplayDispose = autoDisposeOnDisplayDispose;
    }

    public void dispose(Display display) {
        Map<RGB, Color> colorTable = this.displayTable.get(display);
        if (colorTable != null) {
            for (Color color : colorTable.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        Map<RGB, Color> colorTable = this.displayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.displayTable.put(display, colorTable);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        ColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (!this.fAutoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = this.keyTable.get(key);
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        RGB value = this.keyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.keyTable.put(key, rgb);
    }

    public void unbindColor(String key) {
        this.keyTable.remove(key);
    }
}

