/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.runtime;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclList;
import org.eclipse.rcptt.ecl.core.EclMap;
import org.eclipse.rcptt.ecl.core.EclMapEntry;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.EMFStreamPipe;
import org.eclipse.rcptt.ecl.internal.core.IMarkeredPipe;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.IPipe;

public class CoreUtils {
    public static final String INPUT_ANN = "http://www.eclipse.org/ecl/input";
    public static final String INTERNAL_ANN = "http://www.eclipse.org/ecl/internal";
    public static final String META_ANN = "http://www.eclipse.org/ecl/meta";
    public static final String TYPE_DET = "type";

    public static List<String> getMetaTypeList(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(META_ANN);
        if (annotation == null) {
            return null;
        }
        EMap details = annotation.getDetails();
        if (details == null || !details.containsKey((Object)TYPE_DET)) {
            return null;
        }
        String type = (String)details.get((Object)TYPE_DET);
        if (type == null || type.length() == 0) {
            return null;
        }
        String[] types = type.split("\\s*\\|\\s*");
        ArrayList<String> result = new ArrayList<String>(types.length);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String trimmed;
            String t = stringArray[n2];
            if (t.length() != 0 && (trimmed = t.trim()).length() != 0) {
                result.add(trimmed);
            }
            ++n2;
        }
        return result;
    }

    public static Command createCommand(String namespace, String name) throws CoreException {
        return CorePlugin.getScriptletManager().createCommand(namespace, name);
    }

    public static Set<String> getFriendlyNames(String ns, String name) throws CoreException {
        return CorePlugin.getScriptletManager().getFriendlyNames(ns, name);
    }

    public static IMarkeredPipe createEMFPipe(InputStream in, OutputStream out) {
        return new EMFStreamPipe(in, out);
    }

    public static Object createPrimitiveFromString(String value) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    return Boolean.valueOf(value);
                }
                return value;
            }
        }
    }

    public static Class<?> getPrimitiveType(Object o) throws ClassNotFoundException {
        if (o instanceof Integer) {
            return Integer.TYPE;
        }
        if (o instanceof Double) {
            return Double.TYPE;
        }
        if (o instanceof Boolean) {
            return Boolean.TYPE;
        }
        throw new ClassNotFoundException();
    }

    public static List<EStructuralFeature> getFeatures(EClass targetClass) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        final ArrayList<EClass> classes = new ArrayList<EClass>((Collection<EClass>)targetClass.getEAllSuperTypes());
        classes.add(targetClass);
        features.addAll((Collection<EStructuralFeature>)targetClass.getEAllStructuralFeatures());
        Collections.sort(features, new Comparator<EStructuralFeature>(){

            @Override
            public int compare(EStructuralFeature o1, EStructuralFeature o2) {
                try {
                    EClass eClass1 = o1.getEContainingClass();
                    EClass eClass2 = o2.getEContainingClass();
                    int i1 = classes.indexOf(eClass1);
                    int i2 = classes.indexOf(eClass2);
                    return i2 - i1;
                }
                catch (Exception e) {
                    CorePlugin.err(e.getMessage(), e);
                    return 0;
                }
            }
        });
        return features;
    }

    public static String getScriptletNameByClass(EClass eClass) {
        String className = eClass.getName();
        int startPos = className.lastIndexOf(46);
        if (startPos != -1) {
            className = className.substring(startPos);
        }
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        if (className.endsWith("Command")) {
            className = className.substring(0, className.length() - 7);
        }
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (index < className.length()) {
            char symbol = className.charAt(index);
            if (Character.isUpperCase(symbol)) {
                if (index != 0) {
                    result.append('-');
                }
                symbol = Character.toLowerCase(symbol);
            }
            result.append(symbol);
            ++index;
        }
        return result.toString();
    }

    public static List<Object> readPipeContent(IPipe pipe) throws CoreException {
        ArrayList<Object> pipeContent = new ArrayList<Object>();
        Object o = null;
        while (!((o = pipe.take(Long.MAX_VALUE)) instanceof IStatus)) {
            pipeContent.add(o);
        }
        IStatus status = (IStatus)o;
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        return pipeContent;
    }

    public static void featureSafeSet(EObject object, EStructuralFeature feature, List<?> value) throws CoreException {
        CoreUtils.checkBounds(feature, value);
        if (value.size() > 0) {
            value = CoreUtils.convert(value, feature);
            if (feature.getUpperBound() == 1) {
                object.eSet(feature, value.get(0));
            } else {
                object.eSet(feature, value);
            }
        }
    }

    public static List<Object> convert(List<Object> values, EStructuralFeature feature) {
        boolean box = feature instanceof EReference;
        ArrayList<Object> result = new ArrayList<Object>();
        Class clazz = feature.getEType().getInstanceClass();
        for (Object value : values) {
            result.add(CoreUtils.adaptSingleObject(clazz, value, box));
        }
        return result;
    }

    public static Object adaptSingleObject(Class<?> instanceClass, Object item, boolean box) {
        Object rv = Platform.getAdapterManager().getAdapter(item, instanceClass);
        if (rv == null && item != null && instanceClass.isAssignableFrom(String.class)) {
            rv = BoxedValues.unbox(item);
            if (rv instanceof EclList) {
                StringBuilder sb = new StringBuilder();
                for (Object o : ((EclList)rv).getElements()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(CoreUtils.adaptSingleObject(instanceClass, o, false));
                }
                rv = sb.toString();
            } else if (rv instanceof EclMap) {
                StringBuilder sb = new StringBuilder();
                for (EclMapEntry o : ((EclMap)rv).getEntries()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(CoreUtils.adaptSingleObject(instanceClass, o.getKey(), false));
                    sb.append("=");
                    sb.append(CoreUtils.adaptSingleObject(instanceClass, o.getValue(), false));
                }
                rv = sb.toString();
            } else {
                rv = rv.toString();
            }
        }
        if (rv == null) {
            rv = item;
        }
        return box ? BoxedValues.box(rv) : BoxedValues.unbox(rv);
    }

    public static void checkBounds(EStructuralFeature feature, Object value) throws CoreException {
        int actual = 0;
        if (value instanceof List) {
            actual = ((List)value).size();
        } else if (value != null) {
            actual = 1;
        }
        int lower = feature.getLowerBound();
        int upper = feature.getUpperBound();
        if (upper != -1 && actual > upper && upper != 1) {
            throw new CoreException(CorePlugin.err(MessageFormat.format("Parameter {2} is already assigned", actual, upper, feature.getName())));
        }
        if (actual < lower) {
            throw new CoreException(CorePlugin.err(MessageFormat.format("Parameter {2} is not assigned", actual, lower, feature.getName())));
        }
    }

    private CoreUtils() {
        throw new AssertionError();
    }

    public static boolean isBlank(String string) {
        return string == null || string.length() == 0 || string.trim().length() == 0;
    }
}

