/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFileService {
    public static Document readXml(EclFile file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream stream = new FileInputStream(file.toFile());){
                InputSource source = new InputSource(stream);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                return document;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new CoreException(EclDataPlugin.createErr(e, "File not found %s", file.toURI()));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CoreException(EclDataPlugin.createErr(e, "Error reading file %s", file.toURI()));
        }
    }

    public static void writeXml(EclFile file, Document document) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream stream = new FileOutputStream(file.toFile());){
                StreamResult result = new StreamResult(stream);
                document.setXmlStandalone(true);
                DOMSource source = new DOMSource(document);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("standalone", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(source, result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerException e) {
            throw new CoreException(EclDataPlugin.createErr(e, "Error writing file %s", file.toURI()));
        }
    }
}

