/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.project.PDEProject;

public class WorkspaceExportHelper
extends LaunchConfigurationDelegate {
    private IProject[] fWorkspaceProjects;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    public void buildBeforeExport(Object[] exportedItems, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.getExportedWorkspaceProjects(exportedItems);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.build(10, monitor);
            ++n2;
        }
    }

    public Set<IProject> checkForErrors(Object[] exportedItems) throws CoreException {
        IProject[] projects = this.getExportedWorkspaceProjects(exportedItems);
        HashSet<IProject> projectsWithErrors = new HashSet<IProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers.length > 0) {
                IMarker[] iMarkerArray = markers;
                int n3 = markers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    Integer severity = (Integer)marker.getAttribute("severity");
                    if (severity != null && severity >= 2 && (marker.getType().equals("org.eclipse.jdt.core.problem") || marker.getType().equals("org.eclipse.pde.core.problem"))) {
                        projectsWithErrors.add(project);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return projectsWithErrors;
    }

    public Map<String, Map<String, Set<IPath>>> getWorkspaceOutputFolders(Object[] exportedItems) throws CoreException {
        IProject[] projects = this.getExportedWorkspaceProjects(exportedItems);
        LinkedHashMap<String, Map<String, Set<IPath>>> result = new LinkedHashMap<String, Map<String, Set<IPath>>>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IFile buildFile = PDEProject.getBuildProperties(project);
            if (buildFile.exists()) {
                IPluginModelBase model;
                Map<String, Set<IPath>> modelOutput;
                WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
                buildModel.load();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject.exists() && !(modelOutput = this.getPluginOutputFolders(buildModel, javaProject)).isEmpty() && (model = PDECore.getDefault().getModelManager().findModel(project)) != null) {
                    result.put(model.getBundleDescription().getSymbolicName(), modelOutput);
                }
            }
            ++n2;
        }
        return result;
    }

    private Map<String, Set<IPath>> getPluginOutputFolders(IBuildModel buildModel, IJavaProject javaProject) throws JavaModelException {
        IBuildEntry[] buildEntries;
        LinkedHashMap<String, Set<IPath>> outputEntries = new LinkedHashMap<String, Set<IPath>>();
        IBuildEntry[] iBuildEntryArray = buildEntries = buildModel.getBuild().getBuildEntries();
        int n = buildEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry buildEntry = iBuildEntryArray[n2];
            String name = buildEntry.getName();
            if (name.startsWith("source.")) {
                String[] sourceFolders;
                LinkedHashSet<IPath> outputPaths = new LinkedHashSet<IPath>();
                String[] stringArray = sourceFolders = buildEntry.getTokens();
                int n3 = sourceFolders.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry[] classpathEntries;
                    String sourceFolder = stringArray[n4];
                    IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getRawClasspath();
                    int n5 = classpathEntries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IPath sourcePath;
                        IClasspathEntry classpathEntry = iClasspathEntryArray[n6];
                        if (classpathEntry.getEntryKind() == 3 && (sourcePath = classpathEntry.getPath().removeFirstSegments(1)).equals((Object)new Path(sourceFolder))) {
                            IPath outputPath = classpathEntry.getOutputLocation();
                            if (outputPath == null) {
                                outputPath = javaProject.getOutputLocation();
                            }
                            outputPaths.add(outputPath.removeFirstSegments(1));
                        }
                        ++n6;
                    }
                    ++n4;
                }
                if (!outputPaths.isEmpty()) {
                    outputEntries.put(name.substring("source.".length()), outputPaths);
                }
            }
            ++n2;
        }
        return outputEntries;
    }

    private IProject[] getExportedWorkspaceProjects(Object[] exportedItems) throws CoreException {
        if (this.fWorkspaceProjects == null) {
            HashSet<IProject> projects = new HashSet<IProject>();
            Object[] objectArray = exportedItems;
            int n = exportedItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object exportedItem = objectArray[n2];
                if (exportedItem instanceof IPluginModelBase) {
                    Path installLocation = new Path(((IPluginModelBase)exportedItem).getInstallLocation());
                    IProject project = PDECore.getWorkspace().getRoot().getProject(installLocation.lastSegment());
                    if (project.exists()) {
                        projects.add(project);
                    }
                } else if (exportedItem instanceof IFeatureModel) {
                    IFeaturePlugin[] plugins;
                    IFeatureModel feature = (IFeatureModel)exportedItem;
                    IFeaturePlugin[] iFeaturePluginArray = plugins = feature.getFeature().getPlugins();
                    int n3 = plugins.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFeaturePlugin plugin = iFeaturePluginArray[n4];
                        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(plugin.getId());
                        if (model != null) {
                            Path installLocation = new Path(model.getInstallLocation());
                            IProject project = PDECore.getWorkspace().getRoot().getProject(installLocation.lastSegment());
                            if (project.exists()) {
                                projects.add(project);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.fWorkspaceProjects = this.computeReferencedBuildOrder(projects.toArray(new IProject[projects.size()]));
        }
        return this.fWorkspaceProjects;
    }
}

