/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.internal.EclFileResolver;

public class CompositeEclFileResolver
implements EclFileResolver {
    private final List<EclFileResolver> children = new ArrayList<EclFileResolver>();

    public void add(EclFileResolver resolver) {
        this.children.add(resolver);
    }

    @Override
    public EclFile resolve(URI uri) throws IOException {
        EclFile result = this.resolveRaw(uri);
        if (result != null) {
            return result;
        }
        try {
            uri = new URI("file", null, uri.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        result = this.resolveRaw(uri);
        if (result != null) {
            return result;
        }
        throw new IOException("failed to resolve " + uri);
    }

    private EclFile resolveRaw(URI uri) throws IOException {
        for (EclFileResolver child : this.children) {
            EclFile rv = child.resolve(uri);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }
}

