/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.runtime;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Binding;
import org.eclipse.rcptt.ecl.core.Block;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Exec;
import org.eclipse.rcptt.ecl.core.ExecutableParameter;
import org.eclipse.rcptt.ecl.core.LiteralParameter;
import org.eclipse.rcptt.ecl.core.Parallel;
import org.eclipse.rcptt.ecl.core.Parameter;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.ecl.internal.core.ParamConverterManager;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.FQName;
import org.eclipse.rcptt.ecl.runtime.IParamConverter;

public class EclCompiler {
    public static Command compile(Command command) throws CoreException {
        return EclCompiler.compile(command, false);
    }

    public static Command compile(Command command, boolean hasInput) throws CoreException {
        if (command instanceof Exec) {
            Exec exec = (Exec)command;
            return EclCompiler.compile(new FQName(null, EclCommandNameConvention.toScriptletName(exec.getName())), exec.getParameters(), hasInput, false);
        }
        if (command instanceof Block) {
            Block block = (Block)command;
            int i = 0;
            while (i < block.getCommands().size()) {
                boolean innerHasInput = false;
                if (block instanceof Sequence) {
                    innerHasInput = hasInput;
                } else if (block instanceof Pipeline) {
                    innerHasInput = i == 0 ? hasInput : true;
                } else if (block instanceof Parallel) {
                    innerHasInput = hasInput;
                }
                block.getCommands().set(i, (Object)EclCompiler.compile((Command)block.getCommands().get(i), innerHasInput));
                ++i;
            }
        }
        return command;
    }

    public static Command rawCompile(Exec exec, boolean hasInput) throws CoreException {
        return EclCompiler.compile(new FQName(null, EclCommandNameConvention.toScriptletName(exec.getName())), exec.getParameters(), hasInput, true);
    }

    public static Command compile(FQName fqn, List<Parameter> params, boolean hasInput) throws CoreException {
        return EclCompiler.compile(fqn, params, hasInput, false);
    }

    public static Command compile(FQName fqn, List<Parameter> params, boolean hasInput, boolean inDepth) throws CoreException {
        Command target = CoreUtils.createCommand(fqn.ns, fqn.name);
        EClass targetClass = target.eClass();
        List<EStructuralFeature> features = CoreUtils.getFeatures(targetClass);
        HashMap<String, EStructuralFeature> map = new HashMap<String, EStructuralFeature>();
        for (EStructuralFeature feature : features) {
            map.put(feature.getName(), feature);
        }
        int i = 0;
        boolean processUnnamed = EclCompiler.canProcessUnnamed(targetClass);
        for (Parameter param : params) {
            EStructuralFeature feature;
            if (param.eIsSet((EStructuralFeature)CorePackage.eINSTANCE.getParameter_Name())) {
                processUnnamed = false;
            } else if (!processUnnamed) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Unnamed parameters disallowed after named ones");
                throw new CoreException((IStatus)status);
            }
            EStructuralFeature eStructuralFeature = feature = processUnnamed ? features.get(i++) : (EStructuralFeature)map.get(param.getName());
            if (feature == null) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", MessageFormat.format("Invalid parameter name: {0}", param.getName()));
                throw new CoreException((IStatus)status);
            }
            if (processUnnamed && feature.getEAnnotation("http://www.eclipse.org/ecl/input") != null && hasInput) {
                feature = features.get(i++);
            }
            if (feature.getEAnnotation("http://www.eclipse.org/ecl/internal") != null) {
                feature = features.get(i++);
            }
            EclCompiler.evalFeatureValue(target, param, feature, hasInput, inDepth);
            if (feature.getUpperBound() != -1) continue;
            --i;
        }
        return target;
    }

    private static boolean canProcessUnnamed(EClass targetClass) throws CoreException {
        boolean wasOptional = false;
        for (EStructuralFeature feature : targetClass.getEStructuralFeatures()) {
            int lower = feature.getLowerBound();
            int upper = feature.getUpperBound();
            EclCompiler.checkBounds(lower, upper);
            if (lower == 0) {
                wasOptional = true;
                continue;
            }
            if (!wasOptional) continue;
            return false;
        }
        return true;
    }

    private static void checkBounds(int lower, int upper) throws CoreException {
        if (lower < 0) {
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Lower bounds is negative");
            throw new CoreException((IStatus)status);
        }
        if (upper > 1) {
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Upper bounds more than one is not supported yet");
            throw new CoreException((IStatus)status);
        }
    }

    private static void evalFeatureValue(Command target, Parameter param, EStructuralFeature feature, boolean hasInput, boolean inDepth) throws CoreException {
        Object value = null;
        if (param instanceof LiteralParameter) {
            LiteralParameter literal = (LiteralParameter)param;
            Class instanceClass = feature.getEType().getInstanceClass();
            List<String> allowedTypes = CoreUtils.getMetaTypeList(feature);
            try {
                IParamConverter converter;
                if (feature.getEType() instanceof EEnum) {
                    EEnum en = (EEnum)feature.getEType();
                    EEnumLiteral eEnumLiteral = en.getEEnumLiteral(literal.getLiteral());
                    if (eEnumLiteral == null) {
                        Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Invalid constant: " + literal.getLiteral());
                        throw new CoreException((IStatus)status);
                    }
                    value = eEnumLiteral.getInstance();
                }
                if (value == null && (converter = ParamConverterManager.getInstance().getConverter(instanceClass)) != null && (value = (Object)converter.convert(literal, allowedTypes)) instanceof Command && inDepth) {
                    value = EclCompiler.compile((Command)value, true);
                }
                if (value == null && feature.getEType() instanceof EDataType) {
                    value = EcoreUtil.createFromString((EDataType)((EDataType)feature.getEType()), (String)literal.getLiteral());
                }
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Parameter conversion failed: " + e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            if (value == null) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Can't convert value " + literal.getLiteral() + " to type " + instanceClass.getSimpleName());
                throw new CoreException((IStatus)status);
            }
            try {
                if (feature.getUpperBound() == 1) {
                    target.eSet(feature, value);
                }
                List list = (List)target.eGet(feature);
                list.add(value);
            }
            catch (ClassCastException cce) {
                Status status = new Status(4, "org.eclipse.rcptt.ecl.core", "Can't assign value " + value + " to attribute " + feature.getName(), (Throwable)cce);
                throw new CoreException((IStatus)status);
            }
        } else if (param instanceof ExecutableParameter) {
            Binding binding = CoreFactory.eINSTANCE.createBinding();
            binding.setFeature(feature);
            ExecutableParameter execParam = (ExecutableParameter)param;
            binding.setCommand(EclCompiler.compile(execParam.getCommand(), hasInput));
            target.getBindings().add((Object)binding);
        } else {
            throw new RuntimeException("Invalid parameter");
        }
    }
}

