/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.ui.controls.SuggestionItem;
import org.eclipse.rcptt.ui.editors.IScenarioPropertyProvider;

public class PropertySuggestionManager {
    private static PropertySuggestionManager instance;
    private static final String PROPSUGGESTION_EXTPT = "org.eclipse.rcptt.ui.propertySuggestionProviders";
    private static final String PROPSUGGESTION_TESTCASE_ATTR = "scenarioProperties";
    private List<IScenarioPropertyProvider> providers = new ArrayList<IScenarioPropertyProvider>();

    public static PropertySuggestionManager getInstance() {
        if (instance == null) {
            instance = new PropertySuggestionManager();
        }
        return instance;
    }

    public PropertySuggestionManager() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PROPSUGGESTION_EXTPT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IScenarioPropertyProvider provider = (IScenarioPropertyProvider)element.createExecutableExtension(PROPSUGGESTION_TESTCASE_ATTR);
                this.providers.add(provider);
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log((Throwable)e);
            }
            ++n2;
        }
    }

    public List<SuggestionItem> getScenarioProperties(Scenario scenario) {
        ArrayList<SuggestionItem> testCaseProps = new ArrayList<SuggestionItem>();
        for (IScenarioPropertyProvider provider : this.providers) {
            List<SuggestionItem> props = provider.getProperties(scenario);
            if (props == null || props.isEmpty()) continue;
            testCaseProps.addAll(props);
        }
        return testCaseProps;
    }

    public List<SuggestionItem> getScenarioPropertySuggestions(String name) {
        if (name == null || name.equals("")) {
            return Collections.emptyList();
        }
        for (IScenarioPropertyProvider provider : this.providers) {
            List<SuggestionItem> values = provider.getPropertyValues(name);
            if (values == null) continue;
            return values;
        }
        return Collections.emptyList();
    }
}

