/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.rcptt.launching.injection.Directory;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.reporting.core.ReportRendererManager;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;

public class RunnerConfiguration {
    private static final int DEFAULT_EXECUTION_TIMEOUT = 18000;
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 300;
    private static final int DEFAULT_WAIT_AUT_TIMEOUT = 300;
    private static final String SEPARATOR = ";";
    public final List<File> toImport = new ArrayList<File>();
    public String location;
    private String q7ReportLocation = null;
    private String autReportLocation = null;
    public String htmlReportLocation = null;
    public String junitReportLocation = null;
    public final List<String> toTest = new ArrayList<String>();
    public final List<String> suites = new ArrayList<String>();
    public int autCount = 1;
    public String autWorkspacePrefix;
    public String[] autArgs;
    public String[] autVMArgs = new String[0];
    public int timeoutRestart = 2;
    public int connectionResetRetry = 3;
    public boolean splitHTMLReport = false;
    public boolean reuseExistingWorkspace = false;
    public boolean outputMemoryUsage = false;
    public UserReport report = null;
    public String autConsolePrefix = null;
    public int executionTimeout = 18000;
    public int shutdownTimeout = 300;
    public int waitAutTimeout = 300;
    public boolean onlySpecified = false;
    public Map<String, String> testOptions = new HashMap<String, String>();
    public int shudownListenerPort = 0;
    public String javaVM;
    public InjectionConfiguration config = null;
    public int limit = -1;
    public String[] tagsToSkip = new String[]{"skipExecution"};
    public boolean overrideSecurityStorage = true;

    private String getFriendlyName() {
        File autDir;
        String autName;
        String result = "aut-";
        if (this.location != null && (autName = (autDir = new File(this.location)).getName()) != null && autName.length() > 0) {
            result = String.valueOf(result) + autName + "-";
        }
        return result;
    }

    private boolean fillDefaults() {
        File file;
        URL url;
        Location location;
        boolean success;
        if (this.autWorkspacePrefix == null) {
            success = false;
            try {
                File parent;
                location = Platform.getInstanceLocation();
                if (location != null && (url = location.getURL()) != null && (parent = (file = new File(url.toURI())).getParentFile()) != null) {
                    String path;
                    this.autWorkspacePrefix = path = new File(parent.getAbsolutePath(), this.getFriendlyName()).toString();
                    success = true;
                }
            }
            catch (Exception exception) {}
            if (!success) {
                System.out.println("ERROR: Unable to guess wokspace location.");
                return false;
            }
        }
        if (this.autConsolePrefix == null) {
            success = false;
            try {
                location = Platform.getInstanceLocation();
                if (location != null && (url = location.getURL()) != null) {
                    String path;
                    file = new File(url.toURI());
                    this.autConsolePrefix = path = new File(file.getAbsolutePath(), this.getFriendlyName()).toString();
                    success = true;
                }
            }
            catch (Exception exception) {}
            if (!success) {
                System.out.println("ERROR: Unable to guess logs location.");
                return false;
            }
        }
        return true;
    }

    public boolean processArgs(String[] args) {
        Iterator<String> i = Arrays.asList(args).iterator();
        block50: while (i.hasNext()) {
            String arg = i.next();
            CommandArg cmdArg = this.findArg(arg);
            if (cmdArg == null) {
                System.out.println("Invalid argument:" + arg);
                continue;
            }
            switch (cmdArg) {
                case OnlySpecified: {
                    this.onlySpecified = true;
                    break;
                }
                case SplitHTMLReport: {
                    this.splitHTMLReport = true;
                    break;
                }
                case ReuseExisingWorkspace: {
                    this.reuseExistingWorkspace = true;
                    break;
                }
                case MemoryUsage: {
                    this.outputMemoryUsage = true;
                    break;
                }
                case Suites: {
                    String[] suiteArgs;
                    String[] stringArray = suiteArgs = this.getSplitArguments(i);
                    int n = suiteArgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String suite = stringArray[n2];
                        if (!this.suites.contains(suite)) {
                            this.suites.add(suite);
                        }
                        ++n2;
                    }
                    continue block50;
                }
                case Tests: {
                    this.toTest.addAll(new HashSet<String>(Arrays.asList(this.getSplitArguments(i))));
                    break;
                }
                case Report: {
                    String[] arguments = this.getSplitArguments(i);
                    if (arguments.length != 2) {
                        HeadlessRunnerPlugin.getDefault().info("ERROR: Invalid report argument format.");
                        return false;
                    }
                    this.report = new UserReport();
                    this.report.id = arguments[0];
                    this.report.path = arguments[1];
                    ReportRendererManager.ReportRenderer[] renderers = ReportRendererManager.getInstance().getExtensions();
                    String[] stringArray = renderers;
                    int n = renderers.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String reportRenderer = stringArray[n3];
                        if (this.report.id.equals(reportRenderer.getId())) {
                            this.report.renderer = reportRenderer;
                            break;
                        }
                        ++n3;
                    }
                    if (this.report.renderer != null) break;
                    HeadlessRunnerPlugin.getDefault().info("ERROR: Failed to locate report renderer for id: " + this.report.id);
                    System.err.println("ERROR: Failed to locate report renderer for id: " + this.report.id);
                    this.report = null;
                    return false;
                }
                case Q7Report: {
                    this.q7ReportLocation = i.next();
                    break;
                }
                case AUTReport: {
                    this.autReportLocation = i.next();
                    break;
                }
                case HTMLReport: {
                    this.htmlReportLocation = i.next();
                    break;
                }
                case JUnitReport: {
                    this.junitReportLocation = i.next();
                    break;
                }
                case Import: {
                    String[] files;
                    String[] stringArray = files = this.getSplitArguments(i);
                    int n = files.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String filePath = stringArray[n4];
                        File file = new File(filePath);
                        if (!file.exists() || !file.isDirectory()) {
                            System.out.println(String.format("Invalid project location in '-import' arg: %s", filePath));
                        } else if (!this.toImport.contains(file)) {
                            this.toImport.add(file);
                        }
                        ++n4;
                    }
                    continue block50;
                }
                case Location: {
                    if (this.location != null) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: AUT location was specified several times. The last location will be used");
                    }
                    this.location = i.next();
                    File f = new File(this.location);
                    if (!f.exists() || !f.isFile()) continue block50;
                    this.location = f.getParent();
                    break;
                }
                case TimeoutRestartTestCount: {
                    try {
                        this.timeoutRestart = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: AUT Timeout Restart test count must be integer value.");
                    }
                    continue block50;
                }
                case ConnectionResetRetry: {
                    try {
                        this.connectionResetRetry = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: AUT Connection Reset retry count must be an integer value.");
                    }
                    continue block50;
                }
                case Count: {
                    try {
                        this.autCount = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: AUT count parameter must be an integer value.");
                    }
                    continue block50;
                }
                case Limit: {
                    try {
                        this.limit = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: AUT limit parameter must be an integer value.");
                    }
                    continue block50;
                }
                case WsPrefix: {
                    this.autWorkspacePrefix = i.next();
                    break;
                }
                case ExecutionTimeout: {
                    try {
                        this.executionTimeout = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: Execution timeout parameter must be an integer value.");
                    }
                    continue block50;
                }
                case AutArgs: {
                    this.autArgs = this.getSplitArguments(i);
                    break;
                }
                case AutVMArgs: {
                    this.autVMArgs = this.getSplitArguments(i);
                    break;
                }
                case JavaVM: {
                    this.javaVM = i.next();
                    if (new File(this.javaVM).exists()) break;
                    HeadlessRunnerPlugin.getDefault().info("ERROR: Invalid Java VM path: " + this.javaVM);
                    break;
                }
                case UpdateSite: {
                    this.initInjection();
                    String[] split = this.getSplitArguments(i);
                    if (split.length <= 0) break;
                    UpdateSite site = InjectionFactory.eINSTANCE.createUpdateSite();
                    site.setUri(split[0]);
                    if (split.length > 1) {
                        ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                        list.remove(0);
                        site.getUnits().addAll(list);
                    } else {
                        site.setAllUnits(true);
                    }
                    this.config.getEntries().add((Object)site);
                    break;
                }
                case Directory: {
                    this.initInjection();
                    String folder = i.next();
                    Directory directory = InjectionFactory.eINSTANCE.createDirectory();
                    directory.setPath(folder);
                    this.config.getEntries().add((Object)directory);
                    break;
                }
                case ConnectTimeout: {
                    try {
                        String strTimeout = i.next();
                        int timeout = Integer.parseInt(strTimeout);
                        if (timeout < 1) {
                            HeadlessRunnerPlugin.getDefault().info("WARNING: ConnectTimeout value is invalid. Default value will be used...");
                            break;
                        }
                        TeslaFeatures.getInstance().getOption("uijob.aut.startup.timeout").setValue(strTimeout);
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: ConnectTimeout value is invalid. Default value will be used...");
                    }
                    continue block50;
                }
                case TestOptions: {
                    String optionsStr = i.next();
                    Object[] objectArray = optionsStr.split(SEPARATOR);
                    int n = objectArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        CommandArg optionStr = objectArray[n5];
                        if (((String)((Object)optionStr)).trim().length() != 0) {
                            int eqIndex = ((String)((Object)optionStr)).indexOf(61);
                            if (eqIndex == -1) {
                                HeadlessRunnerPlugin.getDefault().info("WARNING: Invalid value for testOptions. should be key1=value1;key2=value2");
                            }
                            String name = ((String)((Object)optionStr)).substring(0, eqIndex).trim();
                            String value = ((String)((Object)optionStr)).substring(eqIndex + 1).trim();
                            if ("overrideSecurityStorage".equals(name)) {
                                this.overrideSecurityStorage = "true".equals(value);
                            } else {
                                this.testOptions.put(name, value);
                            }
                        }
                        ++n5;
                    }
                    continue block50;
                }
                case ShutdownListenerPort: {
                    try {
                        this.shudownListenerPort = Integer.parseInt(i.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: shudownListenerPort parameter must be an integer value.");
                    }
                    continue block50;
                }
                case ConsoleLogsPrefix: {
                    this.autConsolePrefix = i.next();
                    break;
                }
                case TagsToSkip: {
                    this.tagsToSkip = this.getSplitArguments(i);
                    break;
                }
                case NoSecurityStorage: {
                    this.overrideSecurityStorage = false;
                    break;
                }
                case Help: {
                    System.out.println("RCPTT Headless Runner command line arguments:");
                    Object[] objectArray = CommandArg.values();
                    int n = objectArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        CommandArg v = objectArray[n5];
                        System.out.print("\t");
                        String[] commands = v.getCommands();
                        int k = 0;
                        while (k < commands.length) {
                            System.out.print("-" + commands[k]);
                            if (k != commands.length - 1) {
                                System.out.print(", ");
                            }
                            ++k;
                        }
                        System.out.print(":\t" + v.getMessage());
                        System.out.println();
                        ++n5;
                    }
                    return false;
                }
                case ShutdownTimeout: {
                    try {
                        this.shutdownTimeout = Integer.parseInt(i.next());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        HeadlessRunnerPlugin.getDefault().info("WARNING: Shutdown timeout parameter must be an integer value.");
                    }
                }
            }
        }
        return this.fillDefaults();
    }

    private String[] getSplitArguments(Iterator<String> i) {
        if (!i.hasNext()) {
            return new String[0];
        }
        String val = i.next();
        if (val.startsWith("'") && val.endsWith("'")) {
            val = val.substring(1, val.length() - 1);
        }
        if (val.startsWith("\"") && val.endsWith("\"")) {
            val = val.substring(1, val.length() - 1);
        }
        ArrayList<String> splitResult = new ArrayList<String>();
        String[] split = val.split(SEPARATOR);
        splitResult.addAll(Arrays.asList(split));
        if (val.endsWith(SEPARATOR)) {
            splitResult.addAll(Arrays.asList(this.getSplitArguments(i)));
        }
        return splitResult.toArray(new String[splitResult.size()]);
    }

    private void initInjection() {
        if (this.config == null) {
            this.config = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        }
    }

    private CommandArg findArg(String arg) {
        CommandArg[] values;
        CommandArg[] commandArgArray = values = CommandArg.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String[] val;
            CommandArg commandArg = commandArgArray[n2];
            String[] stringArray = val = commandArg.getCommands();
            int n3 = val.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray[n4];
                if (("-" + s).equals(arg) || ("--" + s).equals(arg)) {
                    return commandArg;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public String getQ7ReportLocation() {
        return this.q7ReportLocation != null ? this.q7ReportLocation : new File(RunnerConfiguration.getStateLocationFile(), "q7.report").getAbsolutePath();
    }

    public String getAutReportLocation() {
        return this.autReportLocation != null ? this.autReportLocation : new File(RunnerConfiguration.getStateLocationFile(), "autReport.html").getAbsolutePath();
    }

    private static File getStateLocationFile() {
        return HeadlessRunnerPlugin.getDefault().getStateLocation().toFile();
    }

    static enum CommandArg {
        Location("AUT Product location", "aut"),
        Count("AUT Instances count", "autCount"),
        WsPrefix("AUT workspaces prefix to use. Workspaces will contain numeric number.", "autWsPrefix", "wsPrefix"),
        Suites("Comma separated testsuite names.", "suites"),
        Import("Project to import to AUT workspace", "import"),
        Q7Report("File name of q7 report", "q7report"),
        AUTReport("File name of AUT report about initialization issues", "autReport"),
        HTMLReport("File name of HTML report", "htmlReport"),
        JUnitReport("File path of JUnit report", "junitReport"),
        Report("Comma separated pair of report id, report file name without extension", "report"),
        MemoryUsage("Output memory usage information", "memoryUsage"),
        ExecutionTimeout("Execution timeout (default 18000 seconds (5 hours))", "timeout"),
        Limit("Execute only first N tests)", "limit"),
        AutArgs("Comma separated list of arguments to pass for AUT", "autArgs"),
        AutVMArgs("Comma separated list of arguments to pass to AUT Java VM", "autVMArgs"),
        JavaVM("Java virtual machine to test on. Default: current VM", "autVM", "autJVM", "javaVM"),
        UpdateSite("Comma separated update site location and features required to be injected into AUT", "injection:site", "site"),
        Directory("Location of plugins directory to be injected into AUT.", "injection:dir", "dir"),
        ConnectTimeout("Q7 Connection timeout", "connectTimeout"),
        ConsoleLogsPrefix("Console log prefix", "autConsolePrefix"),
        TimeoutRestartTestCount("Restart AUT then specified amount of tests are failed with timeout (default value is 2, one by one)", "timeoutRestartTestCount"),
        ConnectionResetRetry("Retry tests after connection reset errors", "connectionResetRetry"),
        OnlySpecified("Inject only specified sites", "injectSpecified"),
        NoSecurityStorage("Do not override secure storage location", "noSecurityOverride"),
        TestOptions("Execution options", "testOptions"),
        ShutdownListenerPort("Shutdown Listener Port", "shutdownListenerPort"),
        Help("This message", "help", "h", "?"),
        TagsToSkip("Skip tests with listed tags during execution", "skipTags"),
        SplitHTMLReport("Split HTML Report", "splitHtmlReport"),
        ShutdownTimeout("AUT shutdown timeout (default 300 seconds (5 minutes))", "shutdownTimeout"),
        ReuseExisingWorkspace("When true, treat autWsPrefix as full workspace path and do not change it", "reuseExistingWorkspace"),
        Tests("Semicolon-separated list of test name glob patterns (* - any chars, ? - exactly one char)", "tests");

        private String message;
        private String[] val;

        private CommandArg(String message, String ... val) {
            this.val = val;
            this.message = message;
        }

        public String[] getCommands() {
            return this.val;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class UserReport {
        public String id;
        public String path;
        public ReportRendererManager.ReportRenderer renderer;
    }
}

