/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.AbstractEventProvider;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.core.TeslaProcessorManager;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.swt.widgets.Display;

public class TeslaInfoProvider
extends AbstractEventProvider {
    public static AdvancedInformation getAdvancedInformation() throws InterruptedException, CoreException {
        FutureTask<AdvancedInformation> displayExec = new FutureTask<AdvancedInformation>(new Callable<AdvancedInformation>(){

            @Override
            public AdvancedInformation call() throws Exception {
                AdvancedInformation information = InfoFactory.eINSTANCE.createAdvancedInformation();
                new TeslaProcessorManager().collectInformation(information, null);
                GeneralInformationCollector.collectInformation((AdvancedInformation)information);
                return information;
            }
        });
        Display.getDefault().asyncExec(displayExec);
        try {
            return displayExec.get(15L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e1) {
            throw new CoreException(RcpttPlugin.createStatus((Throwable)e1));
        }
        catch (TimeoutException e1) {
            RcpttPlugin.log((String)"GUI thread is blocked", (Throwable)e1);
            AdvancedInformation information = InfoFactory.eINSTANCE.createAdvancedInformation();
            GeneralInformationCollector.collectInformation((AdvancedInformation)information);
            return information;
        }
    }

    public void storeSnapshot(INodeBuilder node) {
        AdvancedInformation info = TeslaBridge.getLastInfo();
        if (info == null) {
            try {
                info = TeslaInfoProvider.getAdvancedInformation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ReportHelper.addSnapshotWithData((INodeBuilder)node, (EObject)info);
    }

    protected void initializeBuilder(IReportBuilder builder) {
    }
}

