/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.unix;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringMatcher;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class UnixProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_GCONF2 = "gconf-2";
    private static final String LIBRARY_NAME = "gnomeproxy-1.0.0";
    private static final String ENABLE_GNOME = "org.eclipse.core.net.enableGnome";
    private static boolean isGnomeLibLoaded = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        String value = System.getProperty(ENABLE_GNOME);
        if ("".equals(value) || "true".equals(value)) {
            UnixProxyProvider.loadGnomeLib();
        }
    }

    public IProxyData[] select(URI uri) {
        String[] nonProxyHosts = this.getNonProxiedHosts();
        if (nonProxyHosts != null) {
            String host = uri.getHost();
            int npIndex = 0;
            while (npIndex < nonProxyHosts.length) {
                if (this.matchesFilter(host, nonProxyHosts[npIndex])) {
                    return new IProxyData[0];
                }
                ++npIndex;
            }
        }
        IProxyData[] proxies = new IProxyData[]{};
        if (uri.getScheme() != null) {
            IProxyData[] iProxyDataArray;
            ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
            if (pd != null) {
                IProxyData[] iProxyDataArray2 = new IProxyData[1];
                iProxyDataArray = iProxyDataArray2;
                iProxyDataArray2[0] = pd;
            } else {
                iProxyDataArray = new IProxyData[]{};
            }
            proxies = iProxyDataArray;
        } else {
            proxies = this.getProxyData();
        }
        if (Policy.DEBUG) {
            Policy.debug("UnixProxyProvider#select result for [" + uri + "]");
            int i = 0;
            while (i < proxies.length) {
                System.out.println("\t" + proxies[i]);
                ++i;
            }
        }
        return proxies;
    }

    public IProxyData[] getProxyData() {
        String[] commonTypes = new String[]{"HTTP", "SOCKS", "HTTPS"};
        return this.getProxyForTypes(commonTypes);
    }

    private IProxyData[] getProxyForTypes(String[] types) {
        ArrayList<ProxyData> allData = new ArrayList<ProxyData>();
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            ProxyData pd = this.getSystemProxyInfo(type);
            if (pd != null && pd.getHost() != null) {
                allData.add(pd);
            }
            ++i;
        }
        return allData.toArray(new IProxyData[0]);
    }

    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting no_proxy");
        }
        if ((npEnv = UnixProxyProvider.getEnv("no_proxy")) != null) {
            String[] npHosts = StringUtil.split(npEnv, new String[]{","});
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got Env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = UnixProxyProvider.getGConfNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting proxies for: " + protocol);
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = UnixProxyProvider.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got proxyEnv: " + proxyEnv);
            }
            if (proxyEnv != null) {
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(uri.getHost());
                pd.setPort(uri.getPort());
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                pd.setSource("LINUX_ENV");
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Env proxy: " + pd);
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError("Problem during accessing system variable: " + envName, e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = UnixProxyProvider.getGConfProxyInfo(protocol);
                if (pd != null) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome proxy: " + pd);
                    }
                    pd.setSource("LINUX_GNOME");
                    return pd;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return null;
    }

    private static String getEnv(String env) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.System");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method m = clazz.getMethod("getenv", classArray);
            return (String)m.invoke(null, env);
        }
        catch (Throwable throwable) {
            Properties props;
            block20: {
                String[] cmd = new String[]{"/bin/sh", "-c", "env | grep -i proxy"};
                props = new Properties();
                Process proc = null;
                try {
                    proc = Runtime.getRuntime().exec(cmd);
                    props.load(proc.getInputStream());
                }
                catch (IOException e) {
                    Activator.logError("Problem during accessing system variable: " + env, e);
                    if (proc != null) {
                        proc.destroy();
                    }
                    break block20;
                }
                catch (IllegalArgumentException e) {
                    try {
                        Activator.logError("Problem during accessing system variable: " + env, e);
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (proc != null) {
                            proc.destroy();
                        }
                    }
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            return props.getProperty(env);
        }
    }

    private static void loadGnomeLib() {
        block6: {
            try {
                System.loadLibrary(LIBRARY_GCONF2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_GCONF2));
                }
                return;
            }
            try {
                System.loadLibrary(LIBRARY_NAME);
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block6;
                Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_NAME));
            }
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    private boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, true, false);
        return matcher.match(host);
    }

    protected static native void gconfInit();

    protected static native ProxyData getGConfProxyInfo(String var0);

    protected static native String[] getGConfNonProxyHosts();
}

